'********************************************************************
'created	:	2011/09/05
'file base	: 	LRScanTestVB.exe
'
'file ext	:	vb
'author		:	Dong-Hyun Eum & Eun-Taek Lee
'
'purpose	:	Long-Range Scanner VB Demo Program
'Report		:	2012. 01. 13 [01/13/2011 vision7901] v1.0.0 - Release Version
'Report		:	2014. 11. 07 [11/07/2014 TOM       ] v1.0.1 - Release VersionV
'*********************************************************************/
Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports System.Runtime.InteropServices
Imports Microsoft.Win32
Imports System.Threading
Imports System.Reflection
Imports System.IO
Imports LRScannerNet


Public Class LRScanTestVB

    Private m_LRScanner As LRScanner
    Private m_DecoderParams As DECODER_PARAMS

    Public m_bResult As Boolean = False
    Public m_bSyncMode As Boolean = False
    Public m_bWinCE As Boolean = False

    Public m_strVerInfo As String


    Public Const VK_F22 As Long = &H85 'F22(WinCE) 
    Public Const VK_F14 As Long = &H7D 'F14(WM)
    Private m_nHotKeyCE As UInt32
    Private m_nHotKeyWM As UInt32

    Private m_DeviceType As SCAN_DEVICE_TYPE


    Private Sub LRScanTestVB_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        m_LRScanner = New LRScanner()
        AddHandler m_LRScanner.LRScannerDataEvent, AddressOf Me.OnScanRead

        REM Scanner Open
        m_LRScanner.Open()

        m_DeviceType = m_LRScanner.GetDeviceType()

        'OS Type
        If m_DeviceType = SCAN_DEVICE_TYPE.DEVICE_M3UL10_CE Then
            m_bWinCE = True
        ElseIf m_DeviceType = SCAN_DEVICE_TYPE.DEVICE_MM3 Then
            m_bWinCE = False
        End If

        m_nHotKeyCE = UInt32.Parse(VK_F22)
        m_nHotKeyWM = UInt32.Parse(VK_F14)

        If m_bWinCE = True Then
            m_LRScanner.RegHotKey(1, m_nHotKeyCE, m_bSyncMode)
        Else
            m_LRScanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode)
        End If
    End Sub

    Private Sub OnScanRead(ByVal sender As System.Object, ByVal e As LRScannerDataArgs)
        If e.ScanData <> "" Then
            LB_TYPE.Text = e.ScanType
            TB_DATA.Text = e.ScanData
        End If

    End Sub

    Private Sub BN_SCAN_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_SCAN.Click
        m_LRScanner.Read()
    End Sub

    Private Sub BN_SCANCANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_SCANCANCEL.Click
        m_LRScanner.ReadCancel()
    End Sub

    Private Sub BN_SYM_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_SYM.Click
        Dim Symbology As New FSYMBOLOGY()

        m_LRScanner.ReadCancel()
        m_LRScanner.UnRegHotKey(1)

        Symbology.ShowDialog()

        m_LRScanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode)
    End Sub

    Private Sub BN_SCANOPTION_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_SCANOPTION.Click
        Dim ScanOption As New FSCANOPTION()

        ScanOption.m_bSyncMode = m_bSyncMode

        REM Disable Scan Key
        m_LRScanner.ReadCancel()
        m_LRScanner.UnRegHotKey(1)

        If ScanOption.ShowDialog() = DialogResult.OK Then
            m_bSyncMode = ScanOption.m_bSyncMode

            REM Enable Scan Key
            m_LRScanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode)
        End If

    End Sub

    Private Sub BN_NEW_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_NEW.Click

        Dim NewForm As New FTEST()

        m_LRScanner.ReadCancel()

        RemoveHandler m_LRScanner.LRScannerDataEvent, AddressOf Me.OnScanRead

        NewForm.ShowDialog()

        AddHandler m_LRScanner.LRScannerDataEvent, AddressOf Me.OnScanRead

    End Sub

    Private Sub BN_INFO_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_INFO.Click

        Dim AboutDlg As New FABOUT()

        AboutDlg.m_strVersion = m_LRScanner.GetVersionInfo()

        m_LRScanner.ReadCancel()
        m_LRScanner.UnRegHotKey(1)

        AboutDlg.ShowDialog()

        m_LRScanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode)

    End Sub

    Private Sub BN_CLOSE_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_CLOSE.Click
        Close()

        Application.Exit()
    End Sub

    Private Sub LRScanTestVB_Closing(ByVal sender As System.Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
        Dim i As Integer
        Dim bResult As Boolean

        m_LRScanner.UnRegHotKey(1)

        For i = 0 To 3
            bResult = m_LRScanner.Close()
            Thread.Sleep(300)
            If bResult = True Then
                Exit For
            End If

            i = i + 1
        Next
    End Sub
End Class
