﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports LRScannerNet


Public Class FSYMBOLOGY

    Private m_LRScanner As LRScanner
    Public m_Decoder As LRScannerNet.DECODER

    Private m_Codabar As CODABAR_PARAMS
    Private m_Codablock As CODABLOCK_PARAMS
    Private m_Code11 As CODE11_PARAMS
    Private m_Code39 As CODE39_PARAMS
    Private m_Code128 As CODE128_PARAMS
    Private m_Upca As UPCA_PARAMS
    Private m_Upce As UPCE_PARAMS
    Private m_Ean8 As EAN8_PARAMS
    Private m_Ean13 As EAN13_PARAMS
    Private m_Gs1composite As GS1COMPOSITE_PARAMS
    Private m_Gs1databar As GS1DATABAR_PARAMS
    Private m_Int25 As INT25_PARAMS
    Private m_Msi As MSI_PARAMS
    Private m_Plessey As PLESSEY_PARAMS
    Private m_Postnet As POSTNET_PARAMS
    Private m_Standard2of5 As STANDARD2OF5_PARAMS
    Private m_Telepen As TELEPEN_PARAMS

    Private Const AUSPOST As Integer = 0
    Private Const AZTEC As Integer = 1
    Private Const BPO As Integer = 2
    Private Const CANADAPOST As Integer = 3
    Private Const CODABAR As Integer = 4
    Private Const CODABLOCK As Integer = 5
    Private Const CODE11 As Integer = 6
    Private Const CODE39 As Integer = 7
    Private Const CODE93 As Integer = 8
    Private Const CODE128 As Integer = 9
    Private Const DATAMATRIX As Integer = 10
    Private Const DUTCHPOST As Integer = 11
    Private Const UPCA As Integer = 12
    Private Const UPCE As Integer = 13
    Private Const EAN8 As Integer = 14
    Private Const EAN13 As Integer = 15
    Private Const GS1_COMPOSITE As Integer = 16
    Private Const GS1_DATABAR As Integer = 17
    Private Const INFOMAIL As Integer = 18
    Private Const INT25 As Integer = 19
    Private Const JAPANPOST As Integer = 20
    Private Const MATRIX2OF5 As Integer = 21
    Private Const MAXICODE As Integer = 22
    Private Const MSI As Integer = 23
    Private Const PDF417 As Integer = 24
    Private Const MICROPDF As Integer = 25
    Private Const PLANET As Integer = 26
    Private Const PLESSEY As Integer = 27
    Private Const POSTNET As Integer = 28
    Private Const QRCODE As Integer = 29
    Private Const STANDARD2OF5 As Integer = 30
    Private Const SWEDENPOST As Integer = 31
    Private Const TELEPEN As Integer = 32
    Private Const TLC39 As Integer = 33

    Dim BARCODE_TYPE() As String = {"AUSPOST", "AZTEC", "BPO", "CANADAPOST", "CODABAR", "CODABLOCK", "CODE11", "CODE39", "CODE93", "CODE128", "DATAMATRIX", "DUTCHPOST", "UPCA", "UPCE", "EAN8", "EAN13", "GS1_COMPOSITE", "GS1_DATABAR", "INFOMAIL", "INT25", "JAPANPOST", "MATRIX2OF5", "MAXICODE", "MSI", "PDF417", "MICROPDF", "PLANET", "PLESSEY", "POSTNET", "QRCODE", "STANDARD2OF5", "SWEDENPOST", "TELEPEN", "TLC39"}

    Dim BARCODE_ENABLE(49) As Boolean

    Dim Temp As Integer = -1
    Dim Temp_0 As Integer = 0

    Public BarcodeItem As ListViewItem

    Private Sub FSYMBOLOGY_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Dim i As Integer

        m_LRScanner = New LRScanner()
        m_Decoder = New LRScannerNet.DECODER()

        BarcodeItem = New ListViewItem()

        m_LRScanner.GetSymbology(m_Decoder)

        SetCheckBox()

        For i = 0 To 33
            BarcodeItem = New ListViewItem()
            BarcodeItem.Checked = BARCODE_ENABLE(i)
            BarcodeItem.SubItems.Add(BARCODE_TYPE(i))
            Me.LV_SYMLIST.Items.Add(BarcodeItem)
        Next

        BTN_PARAM.Enabled = False


    End Sub

    Private Sub BTN_ALL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_ALL.Click

        Dim i As Integer = 0

        m_LRScanner.SetSymbologyAll()

        SetCheckBox()

        For i = 0 To 33
            If BARCODE_ENABLE(i) = True Then
                LV_SYMLIST.Items(i).Checked = True
            Else
                LV_SYMLIST.Items(i).Checked = False
            End If
        Next
    End Sub

    Private Sub BTN_PARAM_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_PARAM.Click

        Select Case LV_SYMLIST.FocusedItem.Index
            Case CODABAR
                Dim CodabarDlg As New FCODABAR()
                If CodabarDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(CODABAR).Checked = m_Codabar.bEnable
                End If

            Case CODABLOCK
                Dim CodablockDlg As New FCODABLOCK()
                If CodablockDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(CODABLOCK).Checked = m_Codablock.bEnable
                End If
                    
            Case CODE11
                Dim Code11Dlg As New FCODE11()
                If Code11Dlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(CODE11).Checked = m_Code11.bEnable
                End If

            Case CODE128
                Dim Code128Dlg As New FCODE128()
                If Code128Dlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(CODE128).Checked = m_Code128.bEnable
                End If

            Case CODE39
                Dim Code39Dlg As New FCODE39()
                If Code39Dlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(CODE39).Checked = m_Code39.bEnable
                End If

            Case EAN13
                Dim Ean13Dlg As New FEAN13()
                If Ean13Dlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(EAN13).Checked = m_Ean13.bEnable
                End If

            Case EAN8
                Dim Ean8Dlg As New FEAN8()
                If Ean8Dlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(EAN8).Checked = m_Ean8.bEnable
                End If

            Case GS1_COMPOSITE
                Dim Gs1compositeDlg As New FGS1COMPOSITE()
                If Gs1compositeDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(GS1_COMPOSITE).Checked = m_Gs1composite.bEnable
                End If

            Case GS1_DATABAR
                Dim Gs1databarDlg As New FGS1DATABAR()
                If Gs1databarDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(GS1_DATABAR).Checked = m_Gs1databar.bEnable
                End If

            Case INT25
                Dim Int25Dlg As New FINT25()
                If Int25Dlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(INT25).Checked = m_Int25.bEnable
                End If

            Case PLESSEY
                Dim PlesseyDlg As New FPLESSEY()
                If PlesseyDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(PLESSEY).Checked = m_Plessey.bEnable
                End If

            Case POSTNET
                Dim PostnetDlg As New FPOSTNET()
                If PostnetDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(POSTNET).Checked = m_Postnet.bEnable
                End If

            Case STANDARD2OF5
                Dim Standard2of5Dlg As New FSTANDARD2OF5()
                If Standard2of5Dlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(STANDARD2OF5).Checked = m_Standard2of5.bEnable
                End If

            Case TELEPEN
                Dim TelepenDlg As New FTELEPEN()
                If TelepenDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(TELEPEN).Checked = m_Telepen.bEnable
                End If

            Case UPCA
                Dim UpcaDlg As New FUPCA()
                If UpcaDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(UPCA).Checked = m_Upca.bEnable
                End If

            Case UPCE
                Dim UpceDlg As New FUPCE()
                If UpceDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(UPCE).Checked = m_Upce.bEnable
                End If

        End Select


    End Sub

    Private Sub BTN_DAFAULT_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_DAFAULT.Click
        m_LRScanner.SetSymbologyDefault()

        SetCheckBox()

        Dim i As Integer

        For i = 0 To 33
            If BARCODE_ENABLE(i) = True Then
                LV_SYMLIST.Items(i).Checked = True
            Else
                LV_SYMLIST.Items(i).Checked = False
            End If
        Next

    End Sub

    Private Sub OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK.Click

        m_Decoder.bAUSPOST = LV_SYMLIST.Items(0).Checked
        m_Decoder.bAZTEC = LV_SYMLIST.Items(1).Checked
        m_Decoder.bBPO = LV_SYMLIST.Items(2).Checked
        m_Decoder.bCANADAPOST = LV_SYMLIST.Items(3).Checked
        m_Decoder.bCODABAR = LV_SYMLIST.Items(4).Checked
        m_Decoder.bCODABLOCK = LV_SYMLIST.Items(5).Checked
        m_Decoder.bCODE11 = LV_SYMLIST.Items(6).Checked
        m_Decoder.bCODE128 = LV_SYMLIST.Items(7).Checked
        m_Decoder.bCODE39 = LV_SYMLIST.Items(8).Checked
        m_Decoder.bCODE93 = LV_SYMLIST.Items(9).Checked
        m_Decoder.bDATAMATRIX = LV_SYMLIST.Items(10).Checked
        m_Decoder.bDUTCHPOST = LV_SYMLIST.Items(11).Checked
        m_Decoder.bEAN13 = LV_SYMLIST.Items(12).Checked
        m_Decoder.bEAN8 = LV_SYMLIST.Items(13).Checked
        m_Decoder.bGS1_COMPOSITE = LV_SYMLIST.Items(14).Checked
        m_Decoder.bGS1_DATABAR = LV_SYMLIST.Items(15).Checked
        m_Decoder.bINFOMAIL = LV_SYMLIST.Items(16).Checked
        m_Decoder.bINT25 = LV_SYMLIST.Items(17).Checked
        m_Decoder.bJAPANPOST = LV_SYMLIST.Items(18).Checked
        m_Decoder.bMATRIX2OF5 = LV_SYMLIST.Items(19).Checked
        m_Decoder.bMAXICODE = LV_SYMLIST.Items(20).Checked
        m_Decoder.bMICRO_PDF417 = LV_SYMLIST.Items(21).Checked
        m_Decoder.bMSI = LV_SYMLIST.Items(22).Checked
        m_Decoder.bPDF417 = LV_SYMLIST.Items(23).Checked
        m_Decoder.bPLANET = LV_SYMLIST.Items(24).Checked
        m_Decoder.bPLESSEY = LV_SYMLIST.Items(25).Checked
        m_Decoder.bPOSTNET = LV_SYMLIST.Items(26).Checked
        m_Decoder.bQRCODE = LV_SYMLIST.Items(27).Checked
        m_Decoder.bSTANDARD2OF5 = LV_SYMLIST.Items(28).Checked
        m_Decoder.bSWEDENPOST = LV_SYMLIST.Items(29).Checked
        m_Decoder.bTELEPEN = LV_SYMLIST.Items(30).Checked
        m_Decoder.bTLC39 = LV_SYMLIST.Items(31).Checked
        m_Decoder.bUPCA = LV_SYMLIST.Items(32).Checked
        m_Decoder.bUPCE = LV_SYMLIST.Items(33).Checked

        m_LRScanner.SetSymbology(m_Decoder)

        Me.DialogResult = Windows.Forms.DialogResult.OK
    End Sub

    Private Sub BTN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub

    Public Sub SetCheckBox()

        m_LRScanner.GetSymbology(m_Decoder)

        BARCODE_ENABLE(0) = m_Decoder.bAUSPOST
        BARCODE_ENABLE(1) = m_Decoder.bAZTEC
        BARCODE_ENABLE(2) = m_Decoder.bBPO
        BARCODE_ENABLE(3) = m_Decoder.bCANADAPOST
        BARCODE_ENABLE(4) = m_Decoder.bCODABAR
        BARCODE_ENABLE(5) = m_Decoder.bCODABLOCK
        BARCODE_ENABLE(6) = m_Decoder.bCODE11
        BARCODE_ENABLE(7) = m_Decoder.bCODE39
        BARCODE_ENABLE(8) = m_Decoder.bCODE93
        BARCODE_ENABLE(9) = m_Decoder.bCODE128
        BARCODE_ENABLE(10) = m_Decoder.bDATAMATRIX
        BARCODE_ENABLE(11) = m_Decoder.bDUTCHPOST
        BARCODE_ENABLE(12) = m_Decoder.bUPCA
        BARCODE_ENABLE(13) = m_Decoder.bUPCE
        BARCODE_ENABLE(14) = m_Decoder.bEAN8
        BARCODE_ENABLE(15) = m_Decoder.bEAN13
        BARCODE_ENABLE(16) = m_Decoder.bGS1_COMPOSITE
        BARCODE_ENABLE(17) = m_Decoder.bGS1_DATABAR
        BARCODE_ENABLE(18) = m_Decoder.bINFOMAIL
        BARCODE_ENABLE(19) = m_Decoder.bINT25
        BARCODE_ENABLE(20) = m_Decoder.bJAPANPOST
        BARCODE_ENABLE(21) = m_Decoder.bMATRIX2OF5
        BARCODE_ENABLE(22) = m_Decoder.bMAXICODE
        BARCODE_ENABLE(23) = m_Decoder.bMSI
        BARCODE_ENABLE(24) = m_Decoder.bPDF417
        BARCODE_ENABLE(25) = m_Decoder.bMICRO_PDF417
        BARCODE_ENABLE(26) = m_Decoder.bPLANET
        BARCODE_ENABLE(27) = m_Decoder.bPLESSEY
        BARCODE_ENABLE(28) = m_Decoder.bPOSTNET
        BARCODE_ENABLE(29) = m_Decoder.bQRCODE
        BARCODE_ENABLE(30) = m_Decoder.bSTANDARD2OF5
        BARCODE_ENABLE(31) = m_Decoder.bSWEDENPOST
        BARCODE_ENABLE(32) = m_Decoder.bTELEPEN
        BARCODE_ENABLE(33) = m_Decoder.bTLC39

    End Sub

    
    Private Sub LV_SYMLIST_ItemActivate(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LV_SYMLIST.ItemActivate
        Select Case LV_SYMLIST.FocusedItem.Index
            Case AUSPOST, AZTEC, BPO, CANADAPOST, CODE93, DATAMATRIX, DUTCHPOST, INFOMAIL, JAPANPOST, MATRIX2OF5, MAXICODE, PDF417, MICROPDF, PLANET, QRCODE, SWEDENPOST, TLC39
                BTN_PARAM.Enabled = False

            Case CODABAR, CODABLOCK, CODE11, CODE39, CODE128, UPCA, UPCE, EAN8, EAN13, GS1_COMPOSITE, GS1_DATABAR, INT25, MSI, PLESSEY, POSTNET, STANDARD2OF5, TELEPEN
                BTN_PARAM.Enabled = True

        End Select

        If LV_SYMLIST.FocusedItem.Checked = True Then
            LV_SYMLIST.FocusedItem.Checked = False
        Else
            LV_SYMLIST.FocusedItem.Checked = True
        End If

    End Sub
End Class
