﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports LRScannerNet

Public Class FSCANOPTION

    Private m_LRScanner As LRScanner
    Private m_DecoderParams As DECODER_PARAMS

    Public m_bSyncMode As Boolean

    Private Sub FSCANOPTION_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        m_LRScanner = New LRScanner()
        m_DecoderParams = New DECODER_PARAMS()

        m_LRScanner.GetOption(m_DecoderParams)

        If m_bSyncMode Then
            RD_SYNC.Checked = True
        Else
            RD_ASYNC.Checked = True
        End If

        If m_DecoderParams.nSound = 0 Then
            RD_SOUNDDEFAULT.Checked = True
        ElseIf m_DecoderParams.nSound = 1 Then
            RD_BEEP.Checked = True
        Else
            RD_NOSOUND.Checked = True
        End If

        CB_TIMEOUT.SelectedIndex = m_DecoderParams.nTimeOut - 1
        CB_SECURITY.SelectedIndex = m_DecoderParams.nSecurityLevel - 1
        CB_CONTINUE.Checked = m_DecoderParams.bContinueMode
        CB_AIMID.Checked = m_DecoderParams.bXmitAimID
        CB_VIBRATE.Checked = m_DecoderParams.bVibrate
        CB_1DDECODER.Checked = m_DecoderParams.b1DDecodeMode
        CB_CENTERDECODER.Checked = m_DecoderParams.bCenterDecode

    End Sub

    Private Sub BTN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_OK.Click

        If RD_SYNC.Checked Then
            m_bSyncMode = True
        Else
            m_bSyncMode = False
        End If

        If RD_SOUNDDEFAULT.Checked Then
            m_DecoderParams.nSound = 0
        ElseIf RD_BEEP.Checked Then
            m_DecoderParams.nSound = 1
        Else
            m_DecoderParams.nSound = 2
        End If

        m_DecoderParams.nTimeOut = CB_TIMEOUT.SelectedIndex + 1
        m_DecoderParams.nSecurityLevel = CB_SECURITY.SelectedIndex + 1

        m_DecoderParams.bContinueMode = CB_CONTINUE.Checked
        m_DecoderParams.bXmitAimID = CB_AIMID.Checked
        m_DecoderParams.bVibrate = CB_VIBRATE.Checked
        m_DecoderParams.b1DDecodeMode = CB_1DDECODER.Checked
        m_DecoderParams.bCenterDecode = CB_CENTERDECODER.Checked

        m_LRScanner.SetOption(m_DecoderParams)

        Me.DialogResult = Windows.Forms.DialogResult.OK

    End Sub

    Private Sub BTN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub
End Class