﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports LRScannerNet

Public Class FCODE39

    Private m_LRScanner As LRScanner
    Private m_Code39 As CODE39_PARAMS

    Private Sub FCODE39_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        m_LRScanner = New LRScanner()
        m_Code39 = New CODE39_PARAMS()

        m_LRScanner.GetCODE39(m_Code39)

        CB_ENABLE.Checked = m_Code39.bEnable
        CB_CDV.Checked = m_Code39.bCDV
        CB_XCD.Checked = m_Code39.bXCD
        CB_FULLASCII.Checked = m_Code39.bFullASCII

    End Sub

    Private Sub BTN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_OK.Click
        m_Code39.bEnable = CB_ENABLE.Checked
        m_Code39.bCDV = CB_CDV.Checked
        m_Code39.bXCD = CB_XCD.Checked
        m_Code39.bFullASCII = CB_FULLASCII.Checked

        m_LRScanner.SetCODE39(m_Code39)

        Me.DialogResult = Windows.Forms.DialogResult.OK

    End Sub

    Private Sub BTN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub
End Class