﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports LRScannerNet

Public Class FCODE11

    Private m_LRScanner As LRScanner
    Private m_Code11 As CODE11_PARAMS

    Private Sub FCODE11_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        m_LRScanner = New LRScanner()
        m_Code11 = New CODE11_PARAMS()

        m_LRScanner.GetCODE11(m_Code11)

        CB_ENABLE.Checked = m_Code11.bEnable
        CB_CDV.Checked = m_Code11.bCDV

        If m_Code11.bXCD = False Then
            RD_CDV1.Checked = True
        ElseIf m_Code11.bXCD = True Then
            RD_CDV2.Checked = True
        End If


    End Sub

    Private Sub BTN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_OK.Click
        m_Code11.bEnable = CB_ENABLE.Checked
        m_Code11.bCDV = CB_CDV.Checked

        If RD_CDV1.Checked Then
            m_Code11.bXCD = False
        ElseIf RD_CDV2.Checked Then
            m_Code11.bXCD = True
        End If

        m_LRScanner.SetCODE11(m_Code11)

        Me.DialogResult = Windows.Forms.DialogResult.OK

    End Sub

    Private Sub BTN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub
End Class