﻿/********************************************************************
created		:	2011/10/18
file base	: 	LRScanTestNet.exe

file ext	:	cs
author		:	Dong-Hyun Eum & Eun-Taek Lee

purpose		:	Long-Range Scanner C# Demo Program
Report		:	2012. 01. 13 [01/13/2011 vision7901] v1.0.0 - Release Version
*********************************************************************/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using LRScannerNet;

namespace LRScanTestNet
{
    public partial class LRScanTestNet : Form
    {
        private LRScanner m_LRScanner;
        public DECODER_PARAMS m_DecoderParams;

        public bool m_bResult = false;
        public bool m_bSyncMode = false;
        public string m_strVerInfo;
        public bool m_bWinCE = false;

        public const int m_nHotKeyCE = 133;    // VK_F22(WinCE)
        public const int m_nHotKeyWM = 125;    // VK_F14(WM)

        public SCAN_DEVICE_TYPE m_DeviceType;

        public LRScanTestNet()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_LRScanner.LRScannerDataEvent += new LRScannerNet.LRScannerDataDelegate(OnScanRead);

            
            //Scanner Open
            m_LRScanner.Open();
            m_DeviceType = m_LRScanner.GetDeviceType();

            if (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3UL10_CE)
            {
                m_bWinCE = true;
            }
            else if (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_MM3)
            {
                m_bWinCE = false;
            }

            if (m_bWinCE == true)
            {
                m_LRScanner.RegHotKey(1, m_nHotKeyCE, m_bSyncMode);
            }
            else
            {
                m_LRScanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode);
            }
        }
        public void OnScanRead(object sender, LRScannerDataArgs e)
        {
            if (e.ScanData != "")
            {
                LB_TYPE.Text = e.ScanType;
                TB_DATA.Text = e.ScanData;
            }
        }

        private void LRScanTestNet_Closing(object sender, CancelEventArgs e)
        {
            m_LRScanner.UnRegHotKey(1);

            for (int i = 0; i < 3; i++)
            {
                m_bResult = m_LRScanner.Close();
                Thread.Sleep(300);
                if (m_bResult == true)
                    break;
            }
        }

        private void BN_SCAN_Click(object sender, EventArgs e)
        {
            m_LRScanner.Read();
        }

        private void BN_SCANCANCEL_Click(object  sender, EventArgs e)
        {
            m_LRScanner.ReadCancel();
        }        

        private void BN_CLOSE_Click(object sender, EventArgs e)
        {
            Close();

            Application.Exit();
        }

        private void BN_SYM_Click(object sender, EventArgs e)
        {
            FSYMBOLOGY Symbology = new FSYMBOLOGY();

            // Disable Scan Key
            m_LRScanner.ReadCancel();
            m_LRScanner.UnRegHotKey(1);

            Symbology.ShowDialog();

            // Enable Scan Key
            if (m_bWinCE == true)
            {
                m_LRScanner.RegHotKey(1, m_nHotKeyCE, m_bSyncMode);
            }
            else
            {
                m_LRScanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode);
            }
        }

        private void BN_NEW_Click(object sender, EventArgs e)
        {
            FTEST NewForm = new FTEST();

            m_LRScanner.ReadCancel();

            m_LRScanner.LRScannerDataEvent -= new LRScannerNet.LRScannerDataDelegate(OnScanRead);

            this.DialogResult = DialogResult.OK;


            if (NewForm.ShowDialog() == DialogResult.OK)
            {
                m_LRScanner.LRScannerDataEvent += new LRScannerNet.LRScannerDataDelegate(OnScanRead);

            }
        }

        private void BN_SCANOPTION_Click(object sender, EventArgs e)
        {
            FSCANOPTION ScanOption = new FSCANOPTION();

            ScanOption.m_bSyncMode = m_bSyncMode;

            // Disable Scan Key
            m_LRScanner.ReadCancel();
            m_LRScanner.UnRegHotKey(1);

            if (ScanOption.ShowDialog() == DialogResult.OK)
                m_bSyncMode = ScanOption.m_bSyncMode;

            if (m_bWinCE == true)
            {
                m_LRScanner.RegHotKey(1, m_nHotKeyCE, m_bSyncMode);
            }
            else
            {
                m_LRScanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode);
            }
        }

        private void BN_INFO_Click(object sender, EventArgs e)
        {
            FABOUT AboutDlg = new FABOUT();

            AboutDlg.m_strVersion = m_LRScanner.GetVersionInfo();

            // Disable Scan Key
            m_LRScanner.ReadCancel();
            m_LRScanner.UnRegHotKey(1);

            AboutDlg.ShowDialog();

            m_LRScanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode);
        }        

    }
}