﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LRScannerNet;

namespace LRScanTestNet
{
    public partial class FUPCE : Form
    {
        private LRScanner m_LRScanner;
        private UPCE_PARAMS m_Upce;

        public FUPCE()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_Upce = new UPCE_PARAMS();
        }

        private void FUPCE_Load(object sender, EventArgs e)
        {
            m_LRScanner.GetUPCE(out m_Upce);

            CB_ENABLE.Checked = m_Upce.bEnable;
            CB_XNUM.Checked = m_Upce.bXNum;
            CB_XCD.Checked = m_Upce.bXCD;
            CB_UPCATOUPCE.Checked = m_Upce.bUPCE_AS_UPCA;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Upce.bEnable = CB_ENABLE.Checked;
            m_Upce.bXNum = CB_XNUM.Checked;
            m_Upce.bXCD = CB_XCD.Checked;
            m_Upce.bUPCE_AS_UPCA = CB_UPCATOUPCE.Checked;

            m_LRScanner.SetUPCE(ref m_Upce);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}