﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LRScannerNet;
using System.Runtime.InteropServices;
using Microsoft.Win32;
using System.Reflection;
using System.IO;

namespace LRScanTestNet
{
    public partial class FTEST : Form
    {
        private LRScanner m_LRScanner;
        public DECODER_PARAMS m_Decoder;

        public FTEST()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_LRScanner.LRScannerDataEvent += new LRScannerNet.LRScannerDataDelegate(OnScanRead);
        }

        private void BTN_SCAN_Click(object sender, EventArgs e)
        {
            m_LRScanner.Read();
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            m_LRScanner.ReadCancel();
        }

        private void BTN_CLOSE_Click(object sender, EventArgs e)
        {
            Close();
        }

        public void OnScanRead(object sender, LRScannerDataArgs e)
        {
            if (e.ScanData != "")
            {
                LB_TYPE.Text = e.ScanType;
                TB_DATA.Text = e.ScanData;
            }
;
        }

        private void FTEST_Closing(object sender, CancelEventArgs e)
        {
            m_LRScanner.LRScannerDataEvent -= new LRScannerNet.LRScannerDataDelegate(OnScanRead);
            this.DialogResult = DialogResult.OK;
        }

    }
}