﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LRScannerNet;

namespace LRScanTestNet
{
    public partial class FTELEPEN : Form
    {
        private LRScanner m_LRScanner;
        private TELEPEN_PARAMS m_Telepen;

        public FTELEPEN()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_Telepen = new TELEPEN_PARAMS();
        }

        private void FTELEPEN_Load(object sender, EventArgs e)
        {
            m_LRScanner.GetTELEPEN(out m_Telepen);

            CB_ENABLE.Checked = m_Telepen.bEnable;
            CB_NUMERIC.Checked = m_Telepen.bNumeric;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Telepen.bEnable = CB_ENABLE.Checked;
            m_Telepen.bNumeric = CB_NUMERIC.Checked;

            m_LRScanner.SetTELEPEN(ref m_Telepen);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}