﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LRScannerNet;

namespace LRScanTestNet
{
    public partial class FSYMBOLOGY : Form
    {

        private LRScanner m_LRScanner;
        public DECODER m_Decoder;

        public CODABAR_PARAMS m_Codabar;
        public CODABLOCK_PARAMS m_Codablock;
        public CODE11_PARAMS m_Code11;
        public CODE39_PARAMS m_Code39;
        public CODE128_PARAMS m_Code128;
        public UPCA_PARAMS m_Upca;
        public UPCE_PARAMS m_Upce;
        public EAN8_PARAMS m_Ean8;
        public EAN13_PARAMS m_Ean13;
        public GS1COMPOSITE_PARAMS m_Gs1composite;
        public GS1DATABAR_PARAMS m_Gs1databar;
        public INT25_PARAMS m_Int25;
        public MSI_PARAMS m_Msi;
        public PLESSEY_PARAMS m_Plessey;
        public POSTNET_PARAMS m_Postnet;
        public STANDARD2OF5_PARAMS m_Standard2of5;
        public TELEPEN_PARAMS m_Telepen;

        private const int AUSPOST = 0;
        private const int AZTEC = 1;
        private const int BPO = 2;
        private const int CANADAPOST = 3;
        private const int CODABAR = 4;
        private const int CODABLOCK = 5;
        private const int CODE11 = 6;
        private const int CODE39 = 7;
        private const int CODE93 = 8;
        private const int CODE128 = 9;
        private const int DATAMATRIX = 10;
        private const int DUTCHPOST = 11;
        private const int UPCA = 12;
        private const int UPCE = 13;
        private const int EAN8 = 14;
        private const int EAN13 = 15;
        private const int GS1_COMPOSITE = 16;
        private const int GS1_DATABAR = 17;
        private const int INFOMAIL = 18;
        private const int INT25 = 19;
        private const int JAPANPOST = 20;
        private const int MATRIX2OF5 = 21;
        private const int MAXICODE = 22;
        private const int MSI = 23;
        private const int PDF417 = 24;
        private const int MICRO_PDF417 = 25;
        private const int PLANET = 26;
        private const int PLESSEY = 27;
        private const int POSTNET = 28;
        private const int QRCODE = 29;
        private const int STANDARD2OF5 = 30;
        private const int SWEDENPOST = 31;
        private const int TELEPEN = 32;
        private const int TLC39 = 33;

        string[] BARCODE_TYPE = new string[] { "AUSPOST", "AZTEC", "BPO", "ANADAPOST", "CODABAR", "CODABLOCK",
        "CODE11", "CODE39", "CODE93", "CODE128", "DATAMATRIX", "DUTCHPOST", "UPC-A", "UPC-E",
        "EAN-8", "EAN-13", "GS1_COMPOSITE", "GS1_DATABAR", "INFOMAIL", "INT25", "JAPANPOST", "MATRIX2OF5", "MAXICODE", "MSI",
        "PDF417", "MICRO_PDF417", "PLANET", "PLESSEY", "POSTNET", "QRCODE", "STANDARD2OF5", "SWEDENPOST",
        "TELEPEN", "TLC39"};

        bool[] BARCODE_ENABLE = new bool[34];


        public FSYMBOLOGY()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_Decoder = new DECODER();
        }

        private void FSYMBOLOGY_Load(object sender, EventArgs e)
        {
            ListViewItem BarcodeItem = new ListViewItem();

            m_LRScanner.GetSymbology(out m_Decoder);

            SetCheckBox();

            for (int a = 0; a < 34; a++)
            {
                BarcodeItem = new ListViewItem();
                BarcodeItem.Checked = BARCODE_ENABLE[a];
                BarcodeItem.SubItems.Add(BARCODE_TYPE[a]);
                this.LV_SYMLIST.Items.Add(BarcodeItem);
            }

            BTN_PARAM.Enabled = false;
        }

        private void BTN_ALL_Click(object sender, EventArgs e)
        {
            m_LRScanner.SetSymbologyAll();

            SetCheckBox();

            for (int i = 0; i < 34; i++)
            {
                if (BARCODE_ENABLE[i] == true)
                    LV_SYMLIST.Items[i].Checked = true;
                else
                    LV_SYMLIST.Items[i].Checked = false;
            }
        }

        private void BTN_PARAM_Click(object sender, EventArgs e)
        {
            switch (LV_SYMLIST.FocusedItem.Index)
            {
                case CODABAR:
                    FCODABAR CodabarDlg = new FCODABAR();
                    if (CodabarDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[CODABAR].Checked = m_Decoder.bCODABAR;
                    break;

                case CODABLOCK:
                    FCODABLOCK CodablockDlg = new FCODABLOCK();
                    if (CodablockDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[CODABLOCK].Checked = m_Codablock.bEnable;
                    break;

                case CODE11:
                    FCODE11 Code11Dlg = new FCODE11();
                    if (Code11Dlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[CODE11].Checked = m_Code11.bEnable;
                    break;

                case CODE128:
                    FCODE128 Code128Dlg = new FCODE128();
                    if (Code128Dlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[CODE128].Checked = m_Code128.bEnable;
                    break;

                case CODE39:
                    FCODE39 Code39Dlg = new FCODE39();
                    if (Code39Dlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[CODE39].Checked = m_Code39.bEnable;
                    break;

                case EAN13:
                    FEAN13 Ean13Dlg = new FEAN13();
                    if (Ean13Dlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[EAN13].Checked = m_Ean13.bEnable;
                    break;

                case EAN8:
                    FEAN8 Ean8Dlg = new FEAN8();
                    if (Ean8Dlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[EAN8].Checked = m_Ean8.bEnable;
                    break;

                case GS1_COMPOSITE:
                    FGS1COMPOSITE Gs1compositeDlg = new FGS1COMPOSITE();
                    if (Gs1compositeDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[GS1_COMPOSITE].Checked = m_Gs1composite.bEnable;
                    break;

                case GS1_DATABAR:
                    FGS1DATABAR Gs1databarDlg = new FGS1DATABAR();
                    if (Gs1databarDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[GS1_DATABAR].Checked = m_Gs1databar.bEnable;
                    break;

                case INT25:
                    FINT25 Int25Dlg = new FINT25();
                    if (Int25Dlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[INT25].Checked = m_Int25.bEnable;
                    break;

                case PLESSEY:
                    FPLESSEY PlesseyDlg = new FPLESSEY();
                    if (PlesseyDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[PLESSEY].Checked = m_Plessey.bEnable;
                    break;

                case POSTNET:
                    FPOSTNET PostnetDlg = new FPOSTNET();
                    if (PostnetDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[POSTNET].Checked = m_Postnet.bEnable;
                    break;

                case STANDARD2OF5:
                    FSTANDARD2OF5 Standard2of5Dlg = new FSTANDARD2OF5();
                    if (Standard2of5Dlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[STANDARD2OF5].Checked = m_Standard2of5.bEnable;
                    break;

                case TELEPEN:
                    FTELEPEN TelepenDlg = new FTELEPEN();
                    if (TelepenDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[TELEPEN].Checked = m_Telepen.bEnable;
                    break;

                case UPCA:
                    FUPCA UpcaDlg = new FUPCA();
                    if (UpcaDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[UPCA].Checked = m_Upca.bEnable;
                    break;

                case UPCE:
                    FUPCE UpceDlg = new FUPCE();
                    if (UpceDlg.ShowDialog() == DialogResult.OK)
                        LV_SYMLIST.Items[UPCE].Checked = m_Upce.bEnable;
                    break;
                
            }

        }

        private void BTN_DAFAULT_Click(object sender, EventArgs e)
        {
            m_LRScanner.SetSymbologyDefault();

            SetCheckBox();

            for (int i = 0; i < 34; i++)
            {
                if (BARCODE_ENABLE[i] == true)
                    LV_SYMLIST.Items[i].Checked = true;
                else
                    LV_SYMLIST.Items[i].Checked = false;
            }
        }

        private void OK_Click(object sender, EventArgs e)
        {
            m_Decoder.bAUSPOST = LV_SYMLIST.Items[0].Checked;
            m_Decoder.bAZTEC = LV_SYMLIST.Items[1].Checked;
            m_Decoder.bBPO = LV_SYMLIST.Items[2].Checked;
            m_Decoder.bCANADAPOST = LV_SYMLIST.Items[3].Checked;
            m_Decoder.bCODABAR = LV_SYMLIST.Items[4].Checked;
            m_Decoder.bCODABLOCK = LV_SYMLIST.Items[5].Checked;
            m_Decoder.bCODE11 = LV_SYMLIST.Items[6].Checked;
            m_Decoder.bCODE128 = LV_SYMLIST.Items[7].Checked;
            m_Decoder.bCODE39 = LV_SYMLIST.Items[8].Checked;
            m_Decoder.bCODE93 = LV_SYMLIST.Items[9].Checked;
            m_Decoder.bDATAMATRIX = LV_SYMLIST.Items[10].Checked;
            m_Decoder.bDUTCHPOST = LV_SYMLIST.Items[11].Checked;
            m_Decoder.bEAN13 = LV_SYMLIST.Items[12].Checked;
            m_Decoder.bEAN8 = LV_SYMLIST.Items[13].Checked;
            m_Decoder.bGS1_COMPOSITE = LV_SYMLIST.Items[14].Checked;
            m_Decoder.bGS1_DATABAR = LV_SYMLIST.Items[15].Checked;
            m_Decoder.bINFOMAIL = LV_SYMLIST.Items[16].Checked;
            m_Decoder.bINT25 = LV_SYMLIST.Items[17].Checked;
            m_Decoder.bJAPANPOST = LV_SYMLIST.Items[18].Checked;
            m_Decoder.bMATRIX2OF5 = LV_SYMLIST.Items[19].Checked;
            m_Decoder.bMAXICODE = LV_SYMLIST.Items[20].Checked;
            m_Decoder.bMICRO_PDF417 = LV_SYMLIST.Items[21].Checked;
            m_Decoder.bMSI = LV_SYMLIST.Items[22].Checked;
            m_Decoder.bPDF417 = LV_SYMLIST.Items[23].Checked;
            m_Decoder.bPLANET = LV_SYMLIST.Items[24].Checked;
            m_Decoder.bPLESSEY = LV_SYMLIST.Items[25].Checked;
            m_Decoder.bPOSTNET = LV_SYMLIST.Items[26].Checked;
            m_Decoder.bQRCODE = LV_SYMLIST.Items[27].Checked;
            m_Decoder.bSTANDARD2OF5 = LV_SYMLIST.Items[28].Checked;
            m_Decoder.bSWEDENPOST = LV_SYMLIST.Items[29].Checked;
            m_Decoder.bTELEPEN = LV_SYMLIST.Items[30].Checked;
            m_Decoder.bTLC39 = LV_SYMLIST.Items[31].Checked;
            m_Decoder.bUPCA = LV_SYMLIST.Items[32].Checked;
            m_Decoder.bUPCE = LV_SYMLIST.Items[33].Checked;

            m_LRScanner.SetSymbology(ref m_Decoder);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }


        public void SetCheckBox()
        {
            m_LRScanner.GetSymbology(out m_Decoder);

            BARCODE_ENABLE[0] = m_Decoder.bAUSPOST;
            BARCODE_ENABLE[1] = m_Decoder.bAZTEC;
            BARCODE_ENABLE[2] = m_Decoder.bBPO;
            BARCODE_ENABLE[3] = m_Decoder.bCANADAPOST;
            BARCODE_ENABLE[4] = m_Decoder.bCODABAR;
            BARCODE_ENABLE[5] = m_Decoder.bCODABLOCK;
            BARCODE_ENABLE[6] = m_Decoder.bCODE11;
            BARCODE_ENABLE[7] = m_Decoder.bCODE39;
            BARCODE_ENABLE[8] = m_Decoder.bCODE93;
            BARCODE_ENABLE[9] = m_Decoder.bCODE128;
            BARCODE_ENABLE[10] = m_Decoder.bDATAMATRIX;
            BARCODE_ENABLE[11] = m_Decoder.bDUTCHPOST;
            BARCODE_ENABLE[12] = m_Decoder.bUPCA;
            BARCODE_ENABLE[13] = m_Decoder.bUPCE;
            BARCODE_ENABLE[14] = m_Decoder.bEAN8;
            BARCODE_ENABLE[15] = m_Decoder.bEAN13;
            BARCODE_ENABLE[16] = m_Decoder.bGS1_COMPOSITE;
            BARCODE_ENABLE[17] = m_Decoder.bGS1_DATABAR;
            BARCODE_ENABLE[18] = m_Decoder.bINFOMAIL;
            BARCODE_ENABLE[19] = m_Decoder.bINT25;
            BARCODE_ENABLE[20] = m_Decoder.bJAPANPOST;
            BARCODE_ENABLE[21] = m_Decoder.bMATRIX2OF5;
            BARCODE_ENABLE[22] = m_Decoder.bMAXICODE;
            BARCODE_ENABLE[23] = m_Decoder.bMSI;
            BARCODE_ENABLE[24] = m_Decoder.bPDF417;
            BARCODE_ENABLE[25] = m_Decoder.bMICRO_PDF417;
            BARCODE_ENABLE[26] = m_Decoder.bPLANET;
            BARCODE_ENABLE[27] = m_Decoder.bPLESSEY;
            BARCODE_ENABLE[28] = m_Decoder.bPOSTNET;
            BARCODE_ENABLE[29] = m_Decoder.bQRCODE;
            BARCODE_ENABLE[30] = m_Decoder.bSTANDARD2OF5;
            BARCODE_ENABLE[31] = m_Decoder.bSWEDENPOST;
            BARCODE_ENABLE[32] = m_Decoder.bTELEPEN;
            BARCODE_ENABLE[33] = m_Decoder.bTLC39;

        }

        private void LV_SYMLIST_ItemActivate(object sender, EventArgs e)
        {
            switch (LV_SYMLIST.FocusedItem.Index)
            {
                case AUSPOST:
                case AZTEC:
                case BPO:
                case CANADAPOST:
                case CODE93:
                case DATAMATRIX:
                case DUTCHPOST:
                case INFOMAIL:
                case JAPANPOST:
                case MATRIX2OF5:
                case MAXICODE:
                case PDF417:
                case MICRO_PDF417:
                case PLANET:
                case QRCODE:
                case SWEDENPOST:
                case TLC39:
                    BTN_PARAM.Enabled = false;
                    break;

                case CODABAR:
                case CODABLOCK:
                case CODE11:
                case CODE39:
                case CODE128:
                case UPCA:
                case UPCE:
                case EAN8:
                case EAN13:
                case GS1_COMPOSITE:
                case GS1_DATABAR:
                case INT25:
                case MSI:
                case PLESSEY:
                case POSTNET:
                case STANDARD2OF5:
                case TELEPEN:
                    BTN_PARAM.Enabled = true;
                    break;
            }


            if (LV_SYMLIST.FocusedItem.Checked == true)
                LV_SYMLIST.FocusedItem.Checked = false;
            else
                LV_SYMLIST.FocusedItem.Checked = true;
        }

    
    }
}