﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LRScannerNet;

namespace LRScanTestNet
{
    public partial class FSTANDARD2OF5 : Form
    {
        private LRScanner m_LRScanner;
        private STANDARD2OF5_PARAMS m_Standard2of5;

        public FSTANDARD2OF5()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_Standard2of5 = new STANDARD2OF5_PARAMS();
        }

        private void FSTANDARD2OF5_Load(object sender, EventArgs e)
        {
            m_LRScanner.GetSTANDARD2OF5(out m_Standard2of5);

            CB_ENABLE.Checked = m_Standard2of5.bEnable;
            CB_CDV.Checked = m_Standard2of5.bCDV;
            CB_XCD.Checked = m_Standard2of5.bXCD;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Standard2of5.bEnable = CB_ENABLE.Checked;
            m_Standard2of5.bCDV = CB_CDV.Checked;
            m_Standard2of5.bXCD = CB_XCD.Checked;

            m_LRScanner.SetSTANDARD2OF5(ref m_Standard2of5);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}