﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LRScannerNet;

namespace LRScanTestNet
{
    public partial class FSCANOPTION : Form
    {
        private LRScanner m_LRScanner;
        private DECODER_PARAMS m_DecoderParams;

        public bool m_bSyncMode;

        public FSCANOPTION()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_DecoderParams = new DECODER_PARAMS();
        }

        private void FSCANOPTION_Load(object sender, EventArgs e)
        {
            m_LRScanner.GetOption(out m_DecoderParams);

            if (m_bSyncMode)
                RD_SYNC.Checked = true;
            else
                RD_ASYNC.Checked = true;

            if (m_DecoderParams.nSound == 0)
                RD_SOUNDDEFAULT.Checked = true;
            else if (m_DecoderParams.nSound == 1)
                RD_BEEP.Checked = true;
            else
                RD_NOSOUND.Checked = true;

            CB_TIMEOUT.SelectedIndex    = m_DecoderParams.nTimeOut - 1;
            CB_SECURITY.SelectedIndex   = m_DecoderParams.nSecurityLevel - 1;
            CB_CONTINUE.Checked         = m_DecoderParams.bContinueMode;
            CB_AIMID.Checked            = m_DecoderParams.bXmitAimID;
            CB_VIBRATE.Checked          = m_DecoderParams.bVibrate;
            CB_1DDECODER.Checked        = m_DecoderParams.b1DDecodeMode;
            CB_CENTERDECODER.Checked    = m_DecoderParams.bCenterDecode;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            if (RD_SYNC.Checked)
                m_bSyncMode = true;
            else
                m_bSyncMode = false;

            if (RD_SOUNDDEFAULT.Checked)
                m_DecoderParams.nSound = 0;
            else if (RD_BEEP.Checked)
                m_DecoderParams.nSound = 1;
            else
                m_DecoderParams.nSound = 2;

            m_DecoderParams.nTimeOut        = CB_TIMEOUT.SelectedIndex + 1;
            m_DecoderParams.nSecurityLevel  = CB_SECURITY.SelectedIndex + 1;
            m_DecoderParams.bContinueMode   = CB_CONTINUE.Checked; 
            m_DecoderParams.bXmitAimID      = CB_AIMID.Checked;
            m_DecoderParams.bVibrate        = CB_VIBRATE.Checked;
            m_DecoderParams.b1DDecodeMode   = CB_1DDECODER.Checked;
            m_DecoderParams.bCenterDecode   = CB_CENTERDECODER.Checked;

            m_LRScanner.SetOption(ref m_DecoderParams);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}