﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LRScannerNet;

namespace LRScanTestNet
{
    public partial class FPOSTNET : Form
    {
        private LRScanner m_LRScanner;
        private POSTNET_PARAMS m_Postnet;

        public FPOSTNET()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_Postnet = new POSTNET_PARAMS();
        }

        private void FPOSTNET_Load(object sender, EventArgs e)
        {
            m_LRScanner.GetPOSTNET(out m_Postnet);

            CB_ENABLE.Checked = m_Postnet.bEnable;
            CB_XCD.Checked = m_Postnet.bXCD;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Postnet.bEnable = CB_ENABLE.Checked;
            m_Postnet.bXCD = CB_XCD.Checked;

            m_LRScanner.SetPOSTNET(ref m_Postnet);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}