﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LRScannerNet;

namespace LRScanTestNet
{
    public partial class FPLESSEY : Form
    {
        private LRScanner m_LRScanner;
        private PLESSEY_PARAMS m_Plessey;

        public FPLESSEY()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_Plessey = new PLESSEY_PARAMS();
        }

        private void FPLESSEY_Load(object sender, EventArgs e)
        {
            m_LRScanner.GetPLESSEY(out m_Plessey);

            CB_ENABLE.Checked = m_Plessey.bEnable;
            CB_CDV.Checked = m_Plessey.bCDV;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Plessey.bEnable = CB_ENABLE.Checked;
            m_Plessey.bCDV = CB_CDV.Checked;

            m_LRScanner.SetPLESSEY(ref m_Plessey);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}