﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LRScannerNet;

namespace LRScanTestNet
{
    public partial class FMSI : Form
    {
        private LRScanner m_LRScanner;
        private MSI_PARAMS m_Msi;

        public FMSI()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_Msi = new MSI_PARAMS();
        }

        private void FMSI_Load(object sender, EventArgs e)
        {
            m_LRScanner.GetMSI(out m_Msi);

            CB_ENABLE.Checked = m_Msi.bEnable;
            CB_CDV.Checked = m_Msi.bCDV;

            if (m_Msi.bXCD == false)
                RD_MOD10.Checked = true;
            else if (m_Msi.bXCD == true)
                RD_MOD10_10.Checked = true;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Msi.bEnable = CB_ENABLE.Checked;
            m_Msi.bCDV = CB_CDV.Checked;

            if (RD_MOD10.Checked)
                m_Msi.bXCD = false;
            else if (RD_MOD10_10.Checked)
                m_Msi.bXCD = true;

            m_LRScanner.SetMSI(ref m_Msi);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}