﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LRScannerNet;

namespace LRScanTestNet
{
    public partial class FINT25 : Form
    {
        private LRScanner m_LRScanner;
        private INT25_PARAMS m_Int25;

        public FINT25()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_Int25 = new INT25_PARAMS();
        }

        private void FINT25_Load(object sender, EventArgs e)
        {
            m_LRScanner.GetINT25(out m_Int25);

            CB_ENABLE.Checked = m_Int25.bEnable;
            CB_CDV.Checked = m_Int25.bCDV;
            CB_XCD.Checked = m_Int25.bXCD;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Int25.bEnable = CB_ENABLE.Checked;
            m_Int25.bCDV = CB_CDV.Checked;
            m_Int25.bXCD = CB_XCD.Checked;

            m_LRScanner.SetINT25(ref m_Int25);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}