﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LRScannerNet;

namespace LRScanTestNet
{
    public partial class FGS1DATABAR : Form
    {
        private LRScanner m_LRScanner;
        private GS1DATABAR_PARAMS m_Gs1databar;

        public FGS1DATABAR()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_Gs1databar = new GS1DATABAR_PARAMS();
        }

        private void FGS1DATABAR_Load(object sender, EventArgs e)
        {
            m_LRScanner.GetGS1DATABAR(out m_Gs1databar);

            CB_ENABLE.Checked = m_Gs1databar.bEnable;
            CB_GS1LIM.Checked = m_Gs1databar.bGS1LIM;
            CB_GS1EXP.Checked = m_Gs1databar.bGS1EXP;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Gs1databar.bEnable = CB_ENABLE.Checked;
            m_Gs1databar.bGS1LIM = CB_GS1LIM.Checked;
            m_Gs1databar.bGS1EXP = CB_GS1EXP.Checked;

            m_LRScanner.SetGS1DATABAR(ref m_Gs1databar);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}