﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LRScannerNet;

namespace LRScanTestNet
{
    public partial class FGS1COMPOSITE : Form
    {
        private LRScanner m_LRScanner;
        private GS1COMPOSITE_PARAMS m_Gs1composite;

        public FGS1COMPOSITE()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_Gs1composite = new GS1COMPOSITE_PARAMS();
        }

        private void FGS1COMPOSITE_Load(object sender, EventArgs e)
        {
            m_LRScanner.GetGS1COMPOSITE(out m_Gs1composite);

            CB_ENABLE.Checked = m_Gs1composite.bEnable;
            CB_ENABLE_CC.Checked = m_Gs1composite.bCC_C;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Gs1composite.bEnable = CB_ENABLE.Checked;
            m_Gs1composite.bCC_C = CB_ENABLE_CC.Checked;

            m_LRScanner.SetGS1COMPOSITE(ref m_Gs1composite);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}