﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LRScannerNet;

namespace LRScanTestNet
{
    public partial class FCODE128 : Form
    {
        private LRScanner m_LRScanner;
        private CODE128_PARAMS m_Code128;

        public FCODE128()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_Code128 = new CODE128_PARAMS();
        }

        private void FCODE128_Load(object sender, EventArgs e)
        {
            m_LRScanner.GetCODE128(out m_Code128);

            CB_ENABLE.Checked = m_Code128.bEnable;
            CB_GS1128.Checked = m_Code128.bGs1_128;
            CB_ISBT128.Checked = m_Code128.bIsbt128;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Code128.bEnable = CB_ENABLE.Checked;
            m_Code128.bGs1_128 = CB_GS1128.Checked;
            m_Code128.bIsbt128 = CB_ISBT128.Checked;

            m_LRScanner.SetCODE128(ref m_Code128);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }

    }
}