﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LRScannerNet;

namespace LRScanTestNet
{
    public partial class FCODE11 : Form
    {
        private LRScanner m_LRScanner;
        private CODE11_PARAMS m_Code11;

        public FCODE11()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_Code11 = new CODE11_PARAMS();
        }

        private void FCODE11_Load(object sender, EventArgs e)
        {
            m_LRScanner.GetCODE11(out m_Code11);

            CB_ENABLE.Checked = m_Code11.bEnable;
            CB_CDV.Checked = m_Code11.bCDV;

            if (m_Code11.bXCD == false)
                RD_CDV1.Checked = true;
            else if (m_Code11.bXCD == true)
                RD_CDV2.Checked = true;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Code11.bEnable = CB_ENABLE.Checked;
            m_Code11.bCDV = CB_CDV.Checked;

            if (RD_CDV1.Checked)
                m_Code11.bXCD = false;
            else if (RD_CDV2.Checked)
                m_Code11.bXCD = true;

            m_LRScanner.SetCODE11(ref m_Code11);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}