﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LRScannerNet;

namespace LRScanTestNet
{
    public partial class FCODABLOCK : Form
    {
        private LRScanner m_LRScanner;
        private CODABLOCK_PARAMS m_Codablock;

        public FCODABLOCK()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_Codablock = new CODABLOCK_PARAMS();
        }

        private void FCODABLOCK_Load(object sender, EventArgs e)
        {
            m_LRScanner.GetCODABLOCK(out m_Codablock);

            CB_ENABLE_CODABLOCKA.Checked = m_Codablock.bEnable;
            CB_ENABLE_CODABLOCKF.Checked = m_Codablock.bCodaBlock_F;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Codablock.bEnable = CB_ENABLE_CODABLOCKA.Checked;
            m_Codablock.bCodaBlock_F = CB_ENABLE_CODABLOCKF.Checked;

            m_LRScanner.SetCODABLOCK(ref m_Codablock);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}