﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LRScannerNet;

namespace LRScanTestNet
{
    public partial class FCODABAR : Form
    {
        private LRScanner m_LRScanner;
        private CODABAR_PARAMS m_Codabar;

        public FCODABAR()
        {
            InitializeComponent();

            m_LRScanner = new LRScanner();
            m_Codabar = new CODABAR_PARAMS();
        }

        private void FCODABAR_Load(object sender, EventArgs e)
        {
            m_LRScanner.GetCODABAR(out m_Codabar);

            CB_ENABLE.Checked = m_Codabar.bEnable;
            CB_CDV.Checked = m_Codabar.bCDV;
            CB_XCD.Checked = m_Codabar.bXCD;
            CB_XMITSS.Checked = m_Codabar.bXSS;
        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            m_Codabar.bEnable = CB_ENABLE.Checked;
            m_Codabar.bCDV = CB_CDV.Checked;
            m_Codabar.bXCD = CB_XCD.Checked;
            m_Codabar.bXSS = CB_XMITSS.Checked;

            m_LRScanner.SetCODABAR(ref m_Codabar);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}