// UpceDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "UpceDlg.h"
#include "LRScanTestDlg.h"


// CUpceDlg dialog

IMPLEMENT_DYNAMIC(CUpceDlg, CDialog)

CUpceDlg::CUpceDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUpceDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bXNum(FALSE)
	, m_bXCD(FALSE)
	, m_bUpceAsUpca(FALSE)
{

}

CUpceDlg::~CUpceDlg()
{
}

void CUpceDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_XNUM, m_bXNum);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Check(pDX, IDC_CHECK_UPCE_AS_UPCA, m_bUpceAsUpca);
}


BEGIN_MESSAGE_MAP(CUpceDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CUpceDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CUpceDlg message handlers

BOOL CUpceDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PUPCE_PARAMS pUpce = new UPCE_PARAMS();

	if(LRSCAN_GetUPCE(pUpce) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetUPCE()", NULL, MB_TOPMOST);

	m_bEnable		= pUpce->bEnable;
	m_bXCD			= pUpce->bXCD;
	m_bXNum			= pUpce->bXNum;
	m_bUpceAsUpca	= pUpce->bUPCE_AS_UPCA;

	delete pUpce;

	UpdateData(FALSE);

	return TRUE;  
}

void CUpceDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PUPCE_PARAMS pUpce = new UPCE_PARAMS();

	pUpce->bEnable		= m_bEnable;
	pUpce->bXCD			= m_bXCD;
	pUpce->bXNum		= m_bXNum;
	pUpce->bUPCE_AS_UPCA= m_bUpceAsUpca;

	if(LRSCAN_GetUPCE(pUpce) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetUPCE()", NULL, MB_TOPMOST);

	delete pUpce;

	OnOK();
}
