// UpcaDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "UpcaDlg.h"
#include "LRScanTestDlg.h"


// CUpcaDlg dialog

IMPLEMENT_DYNAMIC(CUpcaDlg, CDialog)

CUpcaDlg::CUpcaDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUpcaDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bXNum(FALSE)
	, m_bXCD(FALSE)
	, m_bUpcaAsEan13(FALSE)
	, m_bAddOn(FALSE)
{

}

CUpcaDlg::~CUpcaDlg()
{
}

void CUpcaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_XNUM, m_bXNum);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Check(pDX, IDC_CHECK_UPCA_AS_EAN13, m_bUpcaAsEan13);
	DDX_Check(pDX, IDC_CHECK_ADDON, m_bAddOn);
}


BEGIN_MESSAGE_MAP(CUpcaDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CUpcaDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CUpcaDlg message handlers

BOOL CUpcaDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PUPCA_PARAMS pUpca = new UPCA_PARAMS();

	if(LRSCAN_GetUPCA(pUpca) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetUPCA()", NULL, MB_TOPMOST);

	m_bEnable		= pUpca->bEnable;
	m_bXCD			= pUpca->bXCD;
	m_bXNum			= pUpca->bXNum;
	m_bUpcaAsEan13	= pUpca->bUPCA_AS_EAN13;
	m_bAddOn		= pUpca->bAddOn;

	delete pUpca;

	UpdateData(FALSE);

	return TRUE;  
}

void CUpcaDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PUPCA_PARAMS pUpca = new UPCA_PARAMS();

	pUpca->bEnable			= m_bEnable;
	pUpca->bXCD				= m_bXCD;
	pUpca->bXNum			= m_bXNum;
	pUpca->bUPCA_AS_EAN13	= m_bUpcaAsEan13;
	pUpca->bAddOn			= m_bAddOn;

	if(LRSCAN_SetUPCA(pUpca) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_SetUPCA()", NULL, MB_TOPMOST);

	delete pUpca;

	OnOK();
}
