// TelepenDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "TelepenDlg.h"
#include "LRScanTestDlg.h"


// CTelepenDlg dialog

IMPLEMENT_DYNAMIC(CTelepenDlg, CDialog)

CTelepenDlg::CTelepenDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTelepenDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bNumeric(FALSE)
{

}

CTelepenDlg::~CTelepenDlg()
{
}

void CTelepenDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_NUMERIC, m_bNumeric);
}


BEGIN_MESSAGE_MAP(CTelepenDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CTelepenDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CTelepenDlg message handlers

BOOL CTelepenDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PTELEPEN_PARAMS pTelepen = new TELEPEN_PARAMS();

	if(LRSCAN_GetTELEPEN(pTelepen) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetTELEPEN()", NULL, MB_TOPMOST);

	m_bEnable	= pTelepen->bEnable;
	m_bNumeric	= pTelepen->bNumeric;

	delete pTelepen;

	UpdateData(FALSE);

	return TRUE;  
}

void CTelepenDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PTELEPEN_PARAMS pTelepen = new TELEPEN_PARAMS();

	pTelepen->bEnable		= m_bEnable;
	pTelepen->bNumeric		= m_bNumeric;
	
	if(LRSCAN_SetTELEPEN(pTelepen) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_SetTELEPEN()", NULL, MB_TOPMOST);

	delete pTelepen;

	OnOK();
}
