// SymbologyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "SymbologyDlg.h"
#include "LRScanTestDlg.h"
#include "CodabarDlg.h"
#include "CodablockDlg.h"
#include "Code11Dlg.h"
#include "Code128Dlg.h"
#include "Code39Dlg.h"
#include "Ean13Dlg.h"
#include "Ean8Dlg.h"
#include "Gs1CompositeDlg.h"
#include "Gs1DatabarDlg.h"
#include "Int25Dlg.h"
#include "MsiDlg.h"
#include "PlesseyDlg.h"
#include "PostnetDlg.h"
#include "Standard2of5Dlg.h"
#include "TelepenDlg.h"
#include "UpcaDlg.h"
#include "UpceDlg.h"


// CSymbologyDlg dialog

TCHAR BARCODE_TYPE[][34] = {
	L"AUSPOST", L"AZTEC", L"BRITISH POST", L"CANADA POST", L"CODABAR", L"CODABLOCK",
	L"CODE11", L"CODE39", L"CODE93", L"CODE128", L"DATAMATRIX", L"DUTCH POST", 
	L"UPC-A", L"UPC-E", L"EAN-8", L"EAN-13", L"GS1 COMPOSITE", L"GS1 DATABAR", L"INFOMAIL",
	L"INTERLEAVED 2OF5", L"JAPAN POST", L"MATRIX 2OF5", L"MAXI CODE", L"MSI", L"PDF417",
	L"MICRO PDF417", L"PLANET", L"PLESSEY", L"POSTNET", L"QR CODE", L"STANDARD 2OF5", 
	L"SWEDEN POST", L"TELEPEN", L"TLC39"
};

IMPLEMENT_DYNAMIC(CSymbologyDlg, CDialog)

CSymbologyDlg::CSymbologyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSymbologyDlg::IDD, pParent)
{

}

CSymbologyDlg::~CSymbologyDlg()
{
}

void CSymbologyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_SYMBOLOGY, m_ctrlListSymbology);
	DDX_Control(pDX, IDC_BTN_PARAM, m_ctrlBtnParam);
}


BEGIN_MESSAGE_MAP(CSymbologyDlg, CDialog)
	ON_BN_CLICKED(IDC_BTN_ALL, &CSymbologyDlg::OnBnClickedBtnAll)
	ON_BN_CLICKED(IDC_BTN_PARAM, &CSymbologyDlg::OnBnClickedBtnParam)
	ON_BN_CLICKED(IDC_BTN_DEFAULT, &CSymbologyDlg::OnBnClickedBtnDefault)
	ON_BN_CLICKED(IDOK, &CSymbologyDlg::OnBnClickedOk)
	ON_NOTIFY(NM_CLICK, IDC_LIST_SYMBOLOGY, &CSymbologyDlg::OnNMClickListSymbology)
END_MESSAGE_MAP()


// CSymbologyDlg message handlers

BOOL CSymbologyDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	ListView_SetExtendedListViewStyle(m_ctrlListSymbology.GetSafeHwnd(),LVS_EX_CHECKBOXES | LVS_EX_FULLROWSELECT);

	m_ctrlListSymbology.InsertColumn(0,L"ENABLE",LVCFMT_LEFT,130);
	m_ctrlListSymbology.InsertColumn(1,L"SYMBOLOGY",LVCFMT_LEFT,286);		

	int	i = 0;
	for(i = 33; i>=0; i--)
	{
		m_ctrlListSymbology.CheckAutoCenter();
		m_ctrlListSymbology.InsertItem(0, NULL, 0);
		m_ctrlListSymbology.SetItemText(0, 1, BARCODE_TYPE[i]);		
	}

	SetSymbologyList();	

	return TRUE; 
}

void CSymbologyDlg::OnBnClickedBtnAll()
{
	LRSCAN_SetSymbologyAll();

	SetSymbologyList();

	GetDlgItem(IDC_LIST_SYMBOLOGY)->Invalidate();
}

void CSymbologyDlg::OnBnClickedBtnParam()
{
	CCodabarDlg			CodabarDlg;
	CCodablockDlg		CodablockDlg;
	CCode11Dlg			Code11Dlg;
	CCode128Dlg			Code128Dlg;
	CCode39Dlg			Code39Dlg;
	CEan13Dlg			Ean13Dlg;
	CEan8Dlg			Ean8Dlg;
	CGs1CompositeDlg	Gs1CompositeDlg;
	CGs1DatabarDlg		Gs1DatabarDlg;
	CInt25Dlg			Int25Dlg;
	CMsiDlg				MsiDlg;
	CPlesseyDlg			PlesseyDlg;
	CPostnetDlg			PostnetDlg;
	CStandard2of5Dlg	Standard2of5Dlg;
	CTelepenDlg			TelepenDlg;
	CUpcaDlg			UpcaDlg;
	CUpcaDlg			UpceDlg;

	int nMark = m_ctrlListSymbology.GetSelectionMark();

	switch(nMark)
	{
		case 4:	// Codabar
			CodabarDlg.DoModal();
			SetSymbologyList();
			break;
		case 5: // Codablock
			CodablockDlg.DoModal();
			SetSymbologyList();
			break;
		case 6: // Code11
			Code11Dlg.DoModal();
			SetSymbologyList();
			break;
		case 7: // Code39
			Code39Dlg.DoModal();
			SetSymbologyList();
			break;
		case 9: // code128
			Code128Dlg.DoModal();
			SetSymbologyList();
			break;
		case 12: // UPCA
			UpcaDlg.DoModal();
			SetSymbologyList();
			break;
		case 13: // UPCE
			UpceDlg.DoModal();
			SetSymbologyList();
			break;
		case 14: // EAN-8
			Ean8Dlg.DoModal();
			SetSymbologyList();
			break;
		case 15: // EAN-13
			Ean13Dlg.DoModal();
			SetSymbologyList();
			break;
		case 16: // GS1 Composite
			Gs1CompositeDlg.DoModal();
			SetSymbologyList();
			break;
		case 17: // GS1 DataBar	
			Gs1DatabarDlg.DoModal();
			SetSymbologyList();
			break;
		case 19: // Interleaved 2of5
			Int25Dlg.DoModal();
			SetSymbologyList();
			break;
		case 23: // Msi
			MsiDlg.DoModal();
			SetSymbologyList();
			break;
		case 27: // Plessey
			PlesseyDlg.DoModal();
			SetSymbologyList();
			break;
		case 28: // Postnet
			PostnetDlg.DoModal();
			SetSymbologyList();
			break;
		case 30: //Standard 2of5
			Standard2of5Dlg.DoModal();
			SetSymbologyList();
			break;
		case 32: // Telepen
			TelepenDlg.DoModal();
			SetSymbologyList();
			break;
		default:		
			break;
	}
}

void CSymbologyDlg::OnBnClickedBtnDefault()
{
	LRSCAN_SetSymbologyDefault();

	SetSymbologyList();

	GetDlgItem(IDC_LIST_SYMBOLOGY)->Invalidate();
}

void CSymbologyDlg::OnBnClickedOk()
{
	PDECODER pSym = new DECODER();

	BOOL	bEnable[34] = {0, };
	int		i = 0;

	for(i=0; i<34; i++)
	{
		bEnable[i] = m_ctrlListSymbology.GetCheck(i);		
	}

	pSym->bAUSPOST		= bEnable[0];
	pSym->bAZTEC		= bEnable[1];
	pSym->bBPO			= bEnable[2];
	pSym->bCANADAPOST	= bEnable[3];
	pSym->bCODABAR		= bEnable[4];
	pSym->bCODABLOCK	= bEnable[5];	
	pSym->bCODE11		= bEnable[6];
	pSym->bCODE39		= bEnable[7];
	pSym->bCODE93		= bEnable[8];
	pSym->bCODE128		= bEnable[9];
	pSym->bDATAMATRIX	= bEnable[10];
	pSym->bDUTCHPOST	= bEnable[11];
	pSym->bUPCA			= bEnable[12];
	pSym->bUPCE			= bEnable[13];
	pSym->bEAN8			= bEnable[14];
	pSym->bEAN13		= bEnable[15];
	pSym->bGS1_COMPOSITE= bEnable[16];
	pSym->bGS1_DATABAR	= bEnable[17];	
	pSym->bINFOMAIL		= bEnable[18];
	pSym->bINT25		= bEnable[19];
	pSym->bJAPANPOST	= bEnable[20];
	pSym->bMATRIX2OF5	= bEnable[21];
	pSym->bMAXICODE		= bEnable[22];
	pSym->bMSI			= bEnable[23];
	pSym->bPDF417		= bEnable[24];
	pSym->bMICRO_PDF417	= bEnable[25];
	pSym->bPLANET		= bEnable[26];
	pSym->bPLESSEY		= bEnable[27];
	pSym->bPOSTNET		= bEnable[28];
	pSym->bQRCODE		= bEnable[29];
	pSym->bSTANDARD2OF5	= bEnable[30];
	pSym->bSWEDENPOST	= bEnable[31];
	pSym->bTELEPEN		= bEnable[32];
	pSym->bTLC39		= bEnable[33];

	if(LRSCAN_SetSymbology(pSym) == FALSE)
		::MessageBox(NULL, L"ERROR : LRSCAN_SetSymbology()", NULL, MB_TOPMOST);


	OnOK();
}

void CSymbologyDlg::SetSymbologyList(void)
{
	PDECODER pSym = new DECODER();

	BOOL	bEnable[34] = {0, };
	int		i			= 0;

	if(LRSCAN_GetSymbology(pSym) == FALSE)
		::MessageBox(NULL, L"ERROR : LRSCAN_GetSymbology()", NULL, MB_TOPMOST);

	bEnable[0]	 = pSym->bAUSPOST;
	bEnable[1]	 = pSym->bAZTEC;
	bEnable[2]	 = pSym->bBPO;
	bEnable[3]	 = pSym->bCANADAPOST;
	bEnable[4]	 = pSym->bCODABAR;
	bEnable[5]	 = pSym->bCODABLOCK;
	bEnable[6]	 = pSym->bCODE11;
	bEnable[7]	 = pSym->bCODE39;
	bEnable[8]	 = pSym->bCODE93;
	bEnable[9]	 = pSym->bCODE128;
	bEnable[10]  = pSym->bDATAMATRIX;
	bEnable[11]  = pSym->bDUTCHPOST;
	bEnable[12]  = pSym->bUPCA;
	bEnable[13]  = pSym->bUPCE;
	bEnable[14]  = pSym->bEAN8;
	bEnable[15]  = pSym->bEAN13;
	bEnable[16]  = pSym->bGS1_COMPOSITE;
	bEnable[17]  = pSym->bGS1_DATABAR;
	bEnable[18]  = pSym->bINFOMAIL;
	bEnable[19]  = pSym->bINT25;
	bEnable[20]  = pSym->bJAPANPOST;
	bEnable[21]  = pSym->bMATRIX2OF5;
	bEnable[22]  = pSym->bMAXICODE;
	bEnable[23]  = pSym->bMSI;
	bEnable[24]  = pSym->bPDF417;
	bEnable[25]  = pSym->bMICRO_PDF417;
	bEnable[26]  = pSym->bPLANET;
	bEnable[27]  = pSym->bPLESSEY;
	bEnable[28]  = pSym->bPOSTNET;
	bEnable[29]  = pSym->bQRCODE;
	bEnable[30]  = pSym->bSTANDARD2OF5;
	bEnable[31]  = pSym->bSWEDENPOST;
	bEnable[32]  = pSym->bTELEPEN;
	bEnable[33]  = pSym->bTLC39;

	for(i=0; i<34; i++)
	{
		m_ctrlListSymbology.SetCheck(i, bEnable[i]);	
	}

	delete pSym;

}

void CSymbologyDlg::OnNMClickListSymbology(NMHDR *pNMHDR, LRESULT *pResult)
{
	


	NM_LISTVIEW* pNMLV =  (NM_LISTVIEW*)pNMHDR;

	switch(pNMLV->iItem)
	{
		case 4:	// Codabar
		case 5: // Codablock
		case 6: // Code11
		case 7: // Code39
		case 9: // code128
		case 12: // UPCA
		case 13: // UPCE
		case 14: // EAN-8
		case 15: // EAN-13
		case 16: // GS1 Composite
		case 17: // GS1 DataBar	
		case 19: // Interleaved 2of5
		case 23: // Msi
		case 27: // Plessey
		case 28: // Postnet
		case 30: //Standard 2of5
		case 32: // Telepen
			m_ctrlBtnParam.EnableWindow(TRUE);
			break;
		default:
			m_ctrlBtnParam.EnableWindow(FALSE);
			break;
	}

	if(pNMLV->iItem != -1)
	{
		if(m_ctrlListSymbology.GetCheck(pNMLV->iItem))
			m_ctrlListSymbology.SetCheck(pNMLV->iItem, FALSE);
		else
			m_ctrlListSymbology.SetCheck(pNMLV->iItem, TRUE);
	}

	*pResult = 0;
}
