// Standard2of5Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "Standard2of5Dlg.h"
#include "LRScanTestDlg.h"


// CStandard2of5Dlg dialog

IMPLEMENT_DYNAMIC(CStandard2of5Dlg, CDialog)

CStandard2of5Dlg::CStandard2of5Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CStandard2of5Dlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bCDV(FALSE)
	, m_bXCD(FALSE)
{

}

CStandard2of5Dlg::~CStandard2of5Dlg()
{
}

void CStandard2of5Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_CDV, m_bCDV);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
}


BEGIN_MESSAGE_MAP(CStandard2of5Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CStandard2of5Dlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CStandard2of5Dlg message handlers

BOOL CStandard2of5Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PSTANDARD2OF5_PARAMS pStandard2of5 = new STANDARD2OF5_PARAMS();

	if(LRSCAN_GetSTANDARD2OF5(pStandard2of5) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetSTANDARD2OF5()", NULL, MB_TOPMOST);

	m_bEnable	= pStandard2of5->bEnable;
	m_bCDV		= pStandard2of5->bCDV;
	m_bXCD		= pStandard2of5->bXCD;

	delete pStandard2of5;

	return TRUE; 
}

void CStandard2of5Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PSTANDARD2OF5_PARAMS pStandard2of5 = new STANDARD2OF5_PARAMS();

	pStandard2of5->bEnable	= m_bEnable;
	pStandard2of5->bCDV		= m_bCDV;
	pStandard2of5->bXCD		= m_bXCD;
	
	if(LRSCAN_SetSTANDARD2OF5(pStandard2of5) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_SetSTANDARD2OF5()", NULL, MB_TOPMOST);

	delete pStandard2of5;

	OnOK();
}
