// ScanOptionDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "ScanOptionDlg.h"
#include "LRScanTestDlg.h"


// CScanOptionDlg dialog

IMPLEMENT_DYNAMIC(CScanOptionDlg, CDialog)

CScanOptionDlg::CScanOptionDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CScanOptionDlg::IDD, pParent)
	, m_nSyncMode(0)
	, m_nSound(0)
	, m_bContinueMode(FALSE)
	, m_bAimID(FALSE)
	, m_bVibrate(FALSE)
	, m_b1DDecode(FALSE)
	, m_bCenterDecode(FALSE)
{

}

CScanOptionDlg::~CScanOptionDlg()
{
}

void CScanOptionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Radio(pDX, IDC_RADIO_ASYNC, m_nSyncMode);
	DDX_Radio(pDX, IDC_RADIO_DEFAULT, m_nSound);
	DDX_Control(pDX, IDC_COMBO_TIMEOUT, m_ctrlComboTimeOut);
	DDX_Control(pDX, IDC_COMBO_SECURITYLEVEL, m_ctrlComboSecurityLevel);
	DDX_Check(pDX, IDC_CHECK_CONTINUE, m_bContinueMode);
	DDX_Check(pDX, IDC_CHECK_AIMID, m_bAimID);
	DDX_Check(pDX, IDC_CHECK_VIBRATE, m_bVibrate);
	DDX_Check(pDX, IDC_CHECK_1DDECODE, m_b1DDecode);
	DDX_Check(pDX, IDC_CHECK_CENTERDECODE, m_bCenterDecode);
}


BEGIN_MESSAGE_MAP(CScanOptionDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CScanOptionDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CScanOptionDlg message handlers

BOOL CScanOptionDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	m_ctrlComboTimeOut.InsertString(0, L"1");
	m_ctrlComboTimeOut.InsertString(1, L"2");
	m_ctrlComboTimeOut.InsertString(2, L"3");
	m_ctrlComboTimeOut.InsertString(3, L"4");
	m_ctrlComboTimeOut.InsertString(4, L"5");
	m_ctrlComboTimeOut.InsertString(5, L"6");
	m_ctrlComboTimeOut.InsertString(6, L"7");
	m_ctrlComboTimeOut.InsertString(7, L"8");
	m_ctrlComboTimeOut.InsertString(8, L"9");
	m_ctrlComboTimeOut.InsertString(9, L"10");

	m_ctrlComboSecurityLevel.InsertString(0, L"1");
	m_ctrlComboSecurityLevel.InsertString(1, L"2");
	m_ctrlComboSecurityLevel.InsertString(2, L"3");
	m_ctrlComboSecurityLevel.InsertString(3, L"4");
	m_ctrlComboSecurityLevel.InsertString(4, L"5");
	m_ctrlComboSecurityLevel.InsertString(5, L"6");
	m_ctrlComboSecurityLevel.InsertString(6, L"7");
	m_ctrlComboSecurityLevel.InsertString(7, L"8");
	m_ctrlComboSecurityLevel.InsertString(8, L"9");
	m_ctrlComboSecurityLevel.InsertString(9, L"10");

	GetOption();

	return TRUE;  
}

void CScanOptionDlg::OnBnClickedOk()
{
	if(SetOption() == TRUE)
		OnOK();
}
BOOL CScanOptionDlg::GetOption(void)
{
	CLRScanTestDlg* pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	PDECODER_PARAMS pOption = new DECODER_PARAMS();

	if(LRSCAN_GetOption(pOption) == FALSE)
		::MessageBox(NULL, L"ERROR : LRSCAN_GetOption()", NULL, MB_TOPMOST);

	m_nSyncMode		= pLRScanTestDlg->m_bSyncMode;
	m_nSound		= pOption->nSound;
	m_bContinueMode	= pOption->bContinueMode;
	m_bAimID		= pOption->bXmitAimID;
	m_bVibrate		= pOption->bVibrate;
	m_b1DDecode		= pOption->b1DDecodeMode;
	m_bCenterDecode	= pOption->bCenterDecode;

	m_ctrlComboTimeOut.SetCurSel(pOption->nTimeOut - 1);
	m_ctrlComboSecurityLevel.SetCurSel(pOption->nSecurityLevel - 1);

	delete pOption;

	UpdateData(FALSE);

	return TRUE;
}

BOOL CScanOptionDlg::SetOption(void)
{
	UpdateData(TRUE);

	CLRScanTestDlg* pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	PDECODER_PARAMS pOption = new DECODER_PARAMS();

	pLRScanTestDlg->m_bSyncMode		= m_nSyncMode;
	pOption->nSound					= m_nSound;
	pOption->bContinueMode			= m_bContinueMode;
	pLRScanTestDlg->m_bContinueMode	= m_bContinueMode;
	pOption->bXmitAimID				= m_bAimID;
	pOption->bVibrate				= m_bVibrate;
	pOption->b1DDecodeMode			= m_b1DDecode;
	pOption->bCenterDecode			= m_bCenterDecode;

	if((m_ctrlComboTimeOut.GetCurSel() > 9) || (m_ctrlComboTimeOut.GetCurSel() < 0))
	{
		::MessageBox(NULL, L"Error : Retry set Timeout", NULL, MB_TOPMOST|MB_ICONWARNING);
		GetOption();
		return FALSE;
	}

	if((m_ctrlComboSecurityLevel.GetCurSel() > 9) || (m_ctrlComboSecurityLevel.GetCurSel() < 0))
	{
		::MessageBox(NULL, L"Error : Retry set SecurityLevel", NULL, MB_TOPMOST|MB_ICONWARNING);
		GetOption();
		return FALSE;
	}	

	pOption->nTimeOut		= m_ctrlComboTimeOut.GetCurSel() + 1;
	pOption->nSecurityLevel = m_ctrlComboSecurityLevel.GetCurSel() + 1;

	if(LRSCAN_SetOption(pOption) == FALSE)
	{
		::MessageBox(NULL, L"ERROR : LRSCAN_SetOption()", NULL, MB_TOPMOST);
		return FALSE;
	}

	delete pOption;

	return TRUE;
}
