// PostnetDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "PostnetDlg.h"
#include "LRScanTestDlg.h"


// CPostnetDlg dialog

IMPLEMENT_DYNAMIC(CPostnetDlg, CDialog)

CPostnetDlg::CPostnetDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPostnetDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bXCD(FALSE)
{

}

CPostnetDlg::~CPostnetDlg()
{
}

void CPostnetDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
}


BEGIN_MESSAGE_MAP(CPostnetDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CPostnetDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CPostnetDlg message handlers

BOOL CPostnetDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PPOSTNET_PARAMS	pPostnet = new POSTNET_PARAMS();

	if(LRSCAN_GetPOSTNET(pPostnet) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetPOSTNET()", NULL, MB_TOPMOST);

	m_bEnable	= pPostnet->bEnable;
	m_bXCD		= pPostnet->bXCD;
	
	delete pPostnet;

	UpdateData(FALSE);

	return TRUE;  
}

void CPostnetDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PPOSTNET_PARAMS	pPostnet = new POSTNET_PARAMS();

	pPostnet->bEnable	= m_bEnable;
	pPostnet->bXCD		= m_bXCD;
	
	if(LRSCAN_SetPOSTNET(pPostnet) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_SetPOSTNET()", NULL, MB_TOPMOST);

	delete pPostnet;

	OnOK();
}
