// PlesseyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "PlesseyDlg.h"
#include "LRScanTestDlg.h"


// CPlesseyDlg dialog

IMPLEMENT_DYNAMIC(CPlesseyDlg, CDialog)

CPlesseyDlg::CPlesseyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPlesseyDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bXCD(FALSE)
{

}

CPlesseyDlg::~CPlesseyDlg()
{
}

void CPlesseyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
}


BEGIN_MESSAGE_MAP(CPlesseyDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CPlesseyDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CPlesseyDlg message handlers

BOOL CPlesseyDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PPLESSEY_PARAMS	pPlessey = new PLESSEY_PARAMS();

	if(LRSCAN_GetPLESSEY(pPlessey) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetPLESSEY()", NULL, MB_TOPMOST);

	m_bEnable	= pPlessey->bEnable;
	m_bXCD		= pPlessey->bXCD;

	delete pPlessey;

	UpdateData(FALSE);

	return TRUE; 
}

void CPlesseyDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PPLESSEY_PARAMS	pPlessey = new PLESSEY_PARAMS();

	pPlessey->bEnable	= m_bEnable;
	pPlessey->bXCD		= m_bXCD;
	
	if(LRSCAN_SetPLESSEY(pPlessey) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_SetPLESSEY()", NULL, MB_TOPMOST);

	delete pPlessey;

	OnOK();
}
