// MsiDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "MsiDlg.h"
#include "LRScanTestDlg.h"


// CMsiDlg dialog

IMPLEMENT_DYNAMIC(CMsiDlg, CDialog)

CMsiDlg::CMsiDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMsiDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bXCD(FALSE)
	, m_nCDV(FALSE)
{

}

CMsiDlg::~CMsiDlg()
{
}

void CMsiDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Radio(pDX, IDC_RADIO_MOD10, m_nCDV);
}


BEGIN_MESSAGE_MAP(CMsiDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CMsiDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CMsiDlg message handlers

BOOL CMsiDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PMSI_PARAMS	pMsi = new MSI_PARAMS();

	if(LRSCAN_GetMSI(pMsi) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetMSI()", NULL, MB_TOPMOST);

	m_bEnable	= pMsi->bEnable;
	m_nCDV		= pMsi->bCDV;
	m_bXCD		= pMsi->bXCD;
	
	delete pMsi;

	UpdateData(FALSE);

	return TRUE; 
}

void CMsiDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PMSI_PARAMS	pMsi = new MSI_PARAMS();

	pMsi->bEnable	= m_bEnable;
	pMsi->bCDV		= m_nCDV;
	pMsi->bXCD		= m_bXCD;
	
	if(LRSCAN_SetMSI(pMsi) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_SetMSI()", NULL, MB_TOPMOST);

	delete pMsi;

	OnOK();
}
