/********************************************************************
created		:	2011/10/18
file base	: 	LRScanTest.exe

file ext	:	cpp
author		:	Dong-Hyun Eum & Eun-Taek Lee

purpose		:	Long-Range Scanner C++ Demo Program
Report		:	2012. 01. 13 [01/13/2011 vision7901] v1.0.0 - Release Version
Report		:	2014. 11. 07 [11/07/2014 TOM]		 v1.0.1 - Release Version
*********************************************************************/

#include "stdafx.h"
#include "LRScanTest.h"
#include "LRScanTestDlg.h"
#include "SymbologyDlg.h"
#include "ScanOptionDlg.h"
#include "AboutDlg.h"
#include "TestDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CLRScanTestDlg dialog

CLRScanTestDlg::CLRScanTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLRScanTestDlg::IDD, pParent)
	, m_strStaticType(_T(""))
	, m_strEditData(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CLRScanTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_STATIC_TYPE, m_strStaticType);
	DDX_Text(pDX, IDC_EDIT_DATA, m_strEditData);
}

BEGIN_MESSAGE_MAP(CLRScanTestDlg, CDialog)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_SCAN_DATA, OnScanRead)
	ON_MESSAGE(WM_HOTKEY, OnHotKey)	
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTN_SCAN, &CLRScanTestDlg::OnBnClickedBtnScan)
	ON_BN_CLICKED(IDC_BTN_SCANCANCEL, &CLRScanTestDlg::OnBnClickedBtnScancancel)
	ON_BN_CLICKED(IDC_BTN_SYMBOLOGY, &CLRScanTestDlg::OnBnClickedBtnSymbology)
	ON_BN_CLICKED(IDC_BTN_SCANOPTION, &CLRScanTestDlg::OnBnClickedBtnScanoption)
	ON_BN_CLICKED(IDC_BTN_NEW, &CLRScanTestDlg::OnBnClickedBtnNew)
	ON_BN_CLICKED(IDC_BTN_INFO, &CLRScanTestDlg::OnBnClickedBtnInfo)
	ON_BN_CLICKED(IDC_BTN_CLOSE, &CLRScanTestDlg::OnBnClickedBtnClose)
END_MESSAGE_MAP()


// CLRScanTestDlg message handlers

BOOL CLRScanTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	m_bKeyFlag			= FALSE;	
	m_bSyncMode			= FALSE;
	m_bContinueMode		= FALSE;
	m_bContinueFlag		= FALSE;
	m_bNewForm			= FALSE;

	static CFont fFont;
	LOGFONT LogFont;


	if(GetSystemMetrics(SM_CXSCREEN) == 480)
	{
		GetDlgItem(IDC_STATIC_TYPE)->GetFont()->GetLogFont(&LogFont);
		LogFont.lfWeight = 1400;
		LogFont.lfHeight = 40;
		fFont.CreateFontIndirect(&LogFont);
		GetDlgItem(IDC_STATIC_TYPE)->SetFont(&fFont);

		GetDlgItem(IDC_EDIT_DATA)->GetFont()->GetLogFont(&LogFont);
		LogFont.lfWeight = 1400;
		LogFont.lfHeight = 40;
		fFont.CreateFontIndirect(&LogFont);
		GetDlgItem(IDC_EDIT_DATA)->SetFont(&fFont);

		GetDlgItem(IDC_STATIC_VER)->GetFont()->GetLogFont(&LogFont);
		LogFont.lfWeight = 1400;	
		fFont.CreateFontIndirect(&LogFont);
		GetDlgItem(IDC_STATIC_VER)->SetFont(&fFont);
	}
	else
	{
		GetDlgItem(IDC_STATIC_TYPE)->GetFont()->GetLogFont(&LogFont);
		LogFont.lfWeight = 700;
		LogFont.lfHeight = 20;
		fFont.CreateFontIndirect(&LogFont);
		GetDlgItem(IDC_STATIC_TYPE)->SetFont(&fFont);

		GetDlgItem(IDC_EDIT_DATA)->GetFont()->GetLogFont(&LogFont);
		LogFont.lfWeight = 700;
		LogFont.lfHeight = 20;
		fFont.CreateFontIndirect(&LogFont);
		GetDlgItem(IDC_EDIT_DATA)->SetFont(&fFont);

		GetDlgItem(IDC_STATIC_VER)->GetFont()->GetLogFont(&LogFont);
		LogFont.lfWeight = 700;	
		fFont.CreateFontIndirect(&LogFont);
		GetDlgItem(IDC_STATIC_VER)->SetFont(&fFont);	
	}


	m_strStaticType = L"TYPE";
	m_strEditData = L"DATA";

	// Scanner Open
	if(LRSCAN_Open() == FALSE)
		::MessageBox(NULL, L"ERROR : LRSCAN_Open()", NULL, MB_TOPMOST);

	m_DeviceType = LRSCAN_GetDeviceType();

	if(m_DeviceType == DEVICE_M3UL10_CE)
	{
		// Only for WinCE
		MoveWindow(0, 0, 240, 320);
		m_bWinCE = TRUE;

		RegisterHotKey(this->m_hWnd, HOTKEY_ONE, MOD_KEYUP, VK_F22);
		RegisterHotKey(this->m_hWnd, HOTKEY_TWO, MOD_KEYUP, 0);
		RegisterHotKey(this->m_hWnd, HOTKEY_THREE, MOD_KEYUP, 0);
	}
	else if(m_DeviceType == DEVICE_MM3)
	{
		m_bWinCE = FALSE;

		RegisterHotKey(this->m_hWnd, HOTKEY_ONE, MOD_KEYUP, VK_F14);
		RegisterHotKey(this->m_hWnd, HOTKEY_TWO, MOD_KEYUP, 0);
		RegisterHotKey(this->m_hWnd, HOTKEY_THREE, MOD_KEYUP, 0);
	}

	UpdateData(FALSE);
	
	return TRUE;  
}



void CLRScanTestDlg::OnDestroy()
{
	CDialog::OnDestroy();

	UnregisterHotKey(this->m_hWnd, HOTKEY_ONE);
	UnregisterHotKey(this->m_hWnd, HOTKEY_TWO);
	UnregisterHotKey(this->m_hWnd, HOTKEY_THREE);

	LRSCAN_Close();
}

LRESULT CLRScanTestDlg::OnScanRead(WPARAM wParam, LPARAM lParam)
{
	if(m_bNewForm == TRUE)
		return FALSE;

	TCHAR	szBarType[1024] = {0, };
	TCHAR	szBarData[1024] = {0, };

	LRSCAN_GetScanData(szBarType, szBarData);

	m_strStaticType = szBarType;
	m_strEditData	= szBarData;

	UpdateData(FALSE);

	return LRESULT();
}

LRESULT CLRScanTestDlg::OnHotKey(WPARAM wParam, LPARAM lParam)
{
	if(LOWORD(lParam) == 0x0000 &&(wParam == HOTKEY_ONE ||wParam == HOTKEY_TWO ||wParam == HOTKEY_THREE))
	{
		if(m_bKeyFlag == FALSE)
		{
			m_bKeyFlag = TRUE;

			if(m_bContinueMode == TRUE)
			{
				if(m_bContinueFlag == FALSE)
				{					
					LRSCAN_Read();
					m_bContinueFlag = TRUE;
				}
				else
				{
					LRSCAN_ReadCancel();	
					m_bContinueFlag = FALSE;
				}
			}
			else
			{	
				LRSCAN_Read();	
			}		
		}	
	}
	else if(LOWORD(lParam) == 0x1000 &&(wParam == HOTKEY_ONE ||wParam == HOTKEY_TWO ||wParam == HOTKEY_THREE))
	{
		if(m_bKeyFlag == TRUE)
		{
			m_bKeyFlag = FALSE;

			if(m_bContinueMode == FALSE)
			{
				if(m_bSyncMode == FALSE)
				{		
					LRSCAN_ReadCancel();					
				}			
			}
		}
	}


	return LRESULT();
}

void CLRScanTestDlg::OnBnClickedBtnScan()
{
	LRSCAN_Read();
}

void CLRScanTestDlg::OnBnClickedBtnScancancel()
{
	LRSCAN_ReadCancel();
}

void CLRScanTestDlg::OnBnClickedBtnSymbology()
{
	CSymbologyDlg SymbologyDlg;
	SymbologyDlg.DoModal();
}

void CLRScanTestDlg::OnBnClickedBtnScanoption()
{
	CScanOptionDlg ScanOptionDlg;
	ScanOptionDlg.DoModal();
}

void CLRScanTestDlg::OnBnClickedBtnNew()
{
	m_bNewForm = TRUE;

	CTestDlg TestDlg;

	if(TestDlg.DoModal() == IDOK)
		m_bNewForm = FALSE;
}

void CLRScanTestDlg::OnBnClickedBtnInfo()
{
	CAboutDlg AboutDlg;
	AboutDlg.DoModal();
}

void CLRScanTestDlg::OnBnClickedBtnClose()
{
	CLRScanTestDlg::OnCancel();
}
