// Int25Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "Int25Dlg.h"
#include "LRScanTestDlg.h"


// CInt25Dlg dialog

IMPLEMENT_DYNAMIC(CInt25Dlg, CDialog)

CInt25Dlg::CInt25Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CInt25Dlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bCDV(FALSE)
	, m_bXCD(FALSE)
{

}

CInt25Dlg::~CInt25Dlg()
{
}

void CInt25Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_CDV, m_bCDV);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
}


BEGIN_MESSAGE_MAP(CInt25Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CInt25Dlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CInt25Dlg message handlers

BOOL CInt25Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PINT25_PARAMS	pInt25 = new INT25_PARAMS();

	if(LRSCAN_GetINT25(pInt25) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetINT25()", NULL, MB_TOPMOST);

	m_bEnable	= pInt25->bEnable;
	m_bCDV		= pInt25->bCDV;
	m_bXCD		= pInt25->bXCD;
	
	delete pInt25;

	UpdateData(FALSE);

	return TRUE;  
}

void CInt25Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PINT25_PARAMS	pInt25 = new INT25_PARAMS();

	pInt25->bEnable		= m_bEnable;
	pInt25->bCDV		= m_bCDV;
	pInt25->bXCD		= m_bXCD;
	
	if(LRSCAN_SetINT25(pInt25) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_SetINT25()", NULL, MB_TOPMOST);

	delete pInt25;

	OnOK();
}
