// Gs1DatabarDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "Gs1DatabarDlg.h"
#include "LRScanTestDlg.h"


// CGs1DatabarDlg dialog

IMPLEMENT_DYNAMIC(CGs1DatabarDlg, CDialog)

CGs1DatabarDlg::CGs1DatabarDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGs1DatabarDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bGs1Lim(FALSE)
	, m_bGs1Exp(FALSE)
{

}

CGs1DatabarDlg::~CGs1DatabarDlg()
{
}

void CGs1DatabarDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_GS1_LIM, m_bGs1Lim);
	DDX_Check(pDX, IDC_CHECK_GS1_EXP, m_bGs1Exp);
}


BEGIN_MESSAGE_MAP(CGs1DatabarDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CGs1DatabarDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CGs1DatabarDlg message handlers

BOOL CGs1DatabarDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PGS1DATABAR_PARAMS pGs1Databar = new GS1DATABAR_PARAMS();

	if(LRSCAN_GetGS1DATABAR(pGs1Databar) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetGS1DATABAR()", NULL, MB_TOPMOST);

	m_bEnable = pGs1Databar->bEnable;
	m_bGs1Lim = pGs1Databar->bGS1LIM;
	m_bGs1Exp = pGs1Databar->bGS1EXP;
	
	delete pGs1Databar;

	UpdateData(FALSE);

	return TRUE; 
}

void CGs1DatabarDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PGS1DATABAR_PARAMS	pGs1Databar = new GS1DATABAR_PARAMS();

	pGs1Databar->bEnable	= m_bEnable;
	pGs1Databar->bGS1LIM	= m_bGs1Lim;
	pGs1Databar->bGS1EXP	= m_bGs1Exp;
	
	if(LRSCAN_SetGS1DATABAR(pGs1Databar) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_SetGS1DATABAR()", NULL, MB_TOPMOST);

	delete pGs1Databar;

	OnOK();
}
