// Gs1CompositeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "Gs1CompositeDlg.h"
#include "LRScanTestDlg.h"


// CGs1CompositeDlg dialog

IMPLEMENT_DYNAMIC(CGs1CompositeDlg, CDialog)

CGs1CompositeDlg::CGs1CompositeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGs1CompositeDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bCC_C(FALSE)
{

}

CGs1CompositeDlg::~CGs1CompositeDlg()
{
}

void CGs1CompositeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_CC_C, m_bCC_C);
}


BEGIN_MESSAGE_MAP(CGs1CompositeDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CGs1CompositeDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CGs1CompositeDlg message handlers

BOOL CGs1CompositeDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PGS1COMPOSITE_PARAMS	pGs1Composite = new GS1COMPOSITE_PARAMS();

	if(LRSCAN_GetGS1COMPOSITE(pGs1Composite) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetGS1COMPOSITE()", NULL, MB_TOPMOST);

	m_bEnable	= pGs1Composite->bEnable;
	m_bCC_C		= pGs1Composite->bCC_C;

	delete pGs1Composite;

	UpdateData(FALSE);

	return TRUE;  
}

void CGs1CompositeDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PGS1COMPOSITE_PARAMS	pGs1Composite = new GS1COMPOSITE_PARAMS();

	pGs1Composite->bEnable	= m_bEnable;
	pGs1Composite->bCC_C	= m_bCC_C;;

	if(LRSCAN_SetGS1COMPOSITE(pGs1Composite) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_SetGS1COMPOSITE()", NULL, MB_TOPMOST);

	delete pGs1Composite;

	OnOK();
}
