// Ean13Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "Ean13Dlg.h"
#include "LRScanTestDlg.h"


// CEan13Dlg dialog

IMPLEMENT_DYNAMIC(CEan13Dlg, CDialog)

CEan13Dlg::CEan13Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEan13Dlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bIsxn(FALSE)
	, m_bXCD(FALSE)
	, m_bAddOn(FALSE)
{

}

CEan13Dlg::~CEan13Dlg()
{
}

void CEan13Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK1, m_bIsxn);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Check(pDX, IDC_CHECK_ADDON, m_bAddOn);
}


BEGIN_MESSAGE_MAP(CEan13Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CEan13Dlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CEan13Dlg message handlers

BOOL CEan13Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();


	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PEAN13_PARAMS pEan13 = new EAN13_PARAMS();

	if(LRSCAN_GetEAN13(pEan13) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetEAN13()", NULL, MB_TOPMOST);

	m_bEnable	= pEan13->bEnable;
	m_bIsxn		= pEan13->bISxN;
	m_bXCD		= pEan13->bXCD;
	m_bAddOn	= pEan13->bAddOn;

	delete pEan13;

	UpdateData(FALSE);

	return TRUE;  
}

void CEan13Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PEAN13_PARAMS pEan13 = new EAN13_PARAMS();

	pEan13->bEnable		= m_bEnable;
	pEan13->bISxN		= m_bIsxn;
	pEan13->bXCD		= m_bXCD;
	pEan13->bAddOn		= m_bAddOn;

	if(LRSCAN_SetEAN13(pEan13) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_SetEAN13()", NULL, MB_TOPMOST);

	delete pEan13;

	OnOK();
}
