// Code39Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "Code39Dlg.h"
#include "LRScanTestDlg.h"


// CCode39Dlg dialog

IMPLEMENT_DYNAMIC(CCode39Dlg, CDialog)

CCode39Dlg::CCode39Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCode39Dlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bCDV(FALSE)
	, m_bXCD(FALSE)
	, m_bFullASCII(FALSE)
{

}

CCode39Dlg::~CCode39Dlg()
{
}

void CCode39Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_CDV, m_bCDV);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Check(pDX, IDC_CHECK_FULLASCII, m_bFullASCII);
}


BEGIN_MESSAGE_MAP(CCode39Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCode39Dlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CCode39Dlg message handlers

BOOL CCode39Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	
	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PCODE39_PARAMS	pCode39 = new CODE39_PARAMS();

	if(LRSCAN_GetCODE39(pCode39) == FALSE)
		::MessageBox(NULL, L"Error : IMAGER_GetCODE39()", NULL, MB_TOPMOST);

	m_bEnable		= pCode39->bEnable;
	m_bCDV			= pCode39->bCDV;
	m_bXCD			= pCode39->bXCD;
	m_bFullASCII	= pCode39->bFullASCII;
	
	delete pCode39;

	UpdateData(FALSE);

	return TRUE;  
}

void CCode39Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PCODE39_PARAMS	pCode39 = new CODE39_PARAMS();

	pCode39->bEnable	= m_bEnable;
	pCode39->bCDV		= m_bCDV;
	pCode39->bXCD		= m_bXCD;
	pCode39->bFullASCII	= m_bFullASCII;	

	if(LRSCAN_SetCODE39(pCode39) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetCODE39()", NULL, MB_TOPMOST);

	delete pCode39;

	OnOK();
}
