// Code128Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "Code128Dlg.h"
#include "LRScanTestDlg.h"


// CCode128Dlg dialog

IMPLEMENT_DYNAMIC(CCode128Dlg, CDialog)

CCode128Dlg::CCode128Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCode128Dlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bGs1128(FALSE)
	, m_bIsbt128(FALSE)
{

}

CCode128Dlg::~CCode128Dlg()
{
}

void CCode128Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_GS1_128, m_bGs1128);
	DDX_Check(pDX, IDC_CHECK_ISBT128, m_bIsbt128);
}


BEGIN_MESSAGE_MAP(CCode128Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCode128Dlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CCode128Dlg message handlers

BOOL CCode128Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	


	PCODE128_PARAMS	pCode128 = new CODE128_PARAMS();

	if(LRSCAN_GetCODE128(pCode128) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetCODE128()", NULL, MB_TOPMOST);

	m_bEnable	= pCode128->bEnable;
	m_bGs1128	= pCode128->bGs1_128;
	m_bIsbt128	= pCode128->bIsbt128;
	
	delete pCode128;

	UpdateData(FALSE);

	return TRUE;  
}

void CCode128Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PCODE128_PARAMS	pCode128 = new CODE128_PARAMS();

	pCode128->bEnable	= m_bEnable;
	pCode128->bGs1_128	= m_bGs1128;
	pCode128->bIsbt128	= m_bIsbt128;

	if(LRSCAN_SetCODE128(pCode128) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetCODE128()", NULL, MB_TOPMOST);

	delete pCode128;

	OnOK();
}
