// Code11Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "Code11Dlg.h"
#include "LRScanTestDlg.h"


// CCode11Dlg dialog

IMPLEMENT_DYNAMIC(CCode11Dlg, CDialog)

CCode11Dlg::CCode11Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCode11Dlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_nCDV(FALSE)
	, m_bXCD(FALSE)
{

}

CCode11Dlg::~CCode11Dlg()
{
}

void CCode11Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Radio(pDX, IDC_RADIO_CDV1, m_nCDV);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
}


BEGIN_MESSAGE_MAP(CCode11Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCode11Dlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CCode11Dlg message handlers

BOOL CCode11Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();


	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);

	PCODE11_PARAMS	pCode11 = new CODE11_PARAMS();

	if(LRSCAN_GetCODE11(pCode11) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetCODE11()", NULL, MB_TOPMOST);

	m_bEnable	= pCode11->bEnable;
	m_nCDV		= pCode11->bCDV;
	m_bXCD		= pCode11->bXCD;	

	delete pCode11;

	UpdateData(FALSE);


	return TRUE; 
}

void CCode11Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PCODE11_PARAMS	pCode11 = new CODE11_PARAMS();

	pCode11->bEnable	= m_bEnable;
	pCode11->bCDV		= m_nCDV;
	pCode11->bXCD		= m_bXCD;
	
	if(LRSCAN_SetCODE11(pCode11) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_SetCODE11()", NULL, MB_TOPMOST);

	delete pCode11;

	OnOK();
}
