// CodablockDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "CodablockDlg.h"
#include "LRScanTestDlg.h"


// CCodablockDlg dialog

IMPLEMENT_DYNAMIC(CCodablockDlg, CDialog)

CCodablockDlg::CCodablockDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCodablockDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bCodablockF(FALSE)
{

}

CCodablockDlg::~CCodablockDlg()
{
}

void CCodablockDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_CODABLOCKF, m_bCodablockF);
}


BEGIN_MESSAGE_MAP(CCodablockDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCodablockDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CCodablockDlg message handlers

BOOL CCodablockDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PCODABLOCK_PARAMS	pCodablock = new CODABLOCK_PARAMS();

	if(LRSCAN_GetCODABLOCK(pCodablock) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetCODABLOCK()", NULL, MB_TOPMOST);

	m_bEnable		= pCodablock->bEnable;
	m_bCodablockF	= pCodablock->bCodaBlock_F;

	delete pCodablock;

	UpdateData(FALSE);

	return TRUE;  
}

void CCodablockDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PCODABLOCK_PARAMS	pCodablock = new CODABLOCK_PARAMS();

	pCodablock->bEnable			= m_bEnable;
	pCodablock->bCodaBlock_F	= m_bCodablockF;

	if(LRSCAN_SetCODABLOCK(pCodablock) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_SetCODABLOCK()", NULL, MB_TOPMOST);

	delete pCodablock;

	OnOK();
}
