// CodabarDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LRScanTest.h"
#include "CodabarDlg.h"
#include "LRScanTestDlg.h"


// CCodabarDlg dialog

IMPLEMENT_DYNAMIC(CCodabarDlg, CDialog)

CCodabarDlg::CCodabarDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCodabarDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bCDV(FALSE)
	, m_bXCD(FALSE)
	, m_bXSS(FALSE)
{

}

CCodabarDlg::~CCodabarDlg()
{
}

void CCodabarDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_CDV, m_bCDV);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Check(pDX, IDC_CHECK_XSS, m_bXSS);
}


BEGIN_MESSAGE_MAP(CCodabarDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCodabarDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CCodabarDlg message handlers

BOOL CCodabarDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CLRScanTestDlg*	pLRScanTestDlg = (CLRScanTestDlg*)AfxGetMainWnd();

	if(pLRScanTestDlg->m_bWinCE)
		MoveWindow(0, 0, 240, 320);	

	PCODABAR_PARAMS	pCodabar = new CODABAR_PARAMS();

	if(LRSCAN_GetCODABAR(pCodabar) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_GetCODABAR()", NULL, MB_TOPMOST);

	m_bEnable	= pCodabar->bEnable;
	m_bCDV		= pCodabar->bCDV;
	m_bXCD		= pCodabar->bXCD;
	m_bXSS		= pCodabar->bXSS;

	delete pCodabar;

	UpdateData(FALSE);

	return TRUE;  
}

void CCodabarDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PCODABAR_PARAMS	pCodabar = new CODABAR_PARAMS();

	pCodabar->bEnable	= m_bEnable;
	pCodabar->bCDV		= m_bCDV;
	pCodabar->bXCD		= m_bXCD;
	pCodabar->bXSS		= m_bXSS;

	if(LRSCAN_SetCODABAR(pCodabar) == FALSE)
		::MessageBox(NULL, L"Error : LRSCAN_SetCODABAR()", NULL, MB_TOPMOST);

	delete pCodabar;

	OnOK();
}
