#define LRSCANNER_API __declspec(dllexport)

#define	WM_SCAN_DATA			WM_APP + 350
typedef enum {
	SOUND_DEFAULT = 0,
	SOUND_BEEP,
	SOUND_NONE
} SCAN_SOUND;

typedef enum {
	DEVICE_M3SKY = 0,
	DEVICE_M3SKYSAM,
	DEVICE_MM3,
	DEVICE_M3ORANGE,
	DEVICE_M3SMART_CE,
	DEVICE_M3SMART_WM,
	DEVICE_M3GREEN,
	DEVICE_M3T,
	DEVICE_M3POS,
	DEVICE_M3ORANGEPLUS,
	DEVICE_M3ORANGEPLUS_CE, 
	DEVICE_M3BLACK,
	DEVICE_M3UL10_CE, 
	DEVICE_UNKNOWN 
} SCAN_DEVICE_TYPE;

typedef struct _DECODER{

	// Symbology 34
	BYTE bAUSPOST;
	BYTE bAZTEC;
	BYTE bBPO;
	BYTE bCANADAPOST;
	BYTE bCODABAR;
	BYTE bCODABLOCK;	
	BYTE bCODE11;
	BYTE bCODE39;
	BYTE bCODE93;
	BYTE bCODE128;
	BYTE bDATAMATRIX;
	BYTE bDUTCHPOST;
	BYTE bUPCA;
	BYTE bUPCE;
	BYTE bEAN8;
	BYTE bEAN13;
	BYTE bGS1_COMPOSITE;	
	BYTE bGS1_DATABAR;	
	BYTE bINFOMAIL;
	BYTE bINT25;
	BYTE bJAPANPOST;
	BYTE bMATRIX2OF5;
	BYTE bMAXICODE;
	BYTE bMSI;
	BYTE bPDF417;
	BYTE bMICRO_PDF417;
	BYTE bPLANET;
	BYTE bPLESSEY;
	BYTE bPOSTNET;
	BYTE bQRCODE;
	BYTE bSTANDARD2OF5;
	BYTE bSWEDENPOST;
	BYTE bTELEPEN;
	BYTE bTLC39;

}DECODER, *PDECODER;

typedef struct _DECODER_PARAMS{
	BYTE bContinueMode;
	BYTE bXmitAimID;
	BYTE bVibrate;	
	BYTE b1DDecodeMode;
	BYTE bCenterDecode;
	int	 nSound;
	int	 nTimeOut;	
	int	 nSecurityLevel;	
}DECODER_PARAMS, *PDECODER_PARAMS;

typedef struct _CODABAR_PARAMS{
	BYTE	bEnable;
	BYTE	bXSS;
	BYTE	bCDV;
	BYTE	bXCD;
}CODABAR_PARAMS, *PCODABAR_PARAMS;

typedef struct _CODABLOCK_PARAMS{
	BYTE	bEnable;
	BYTE	bCodaBlock_F;
}CODABLOCK_PARAMS, *PCODABLOCK_PARAMS;

typedef struct _CODE11_PARAMS{
	BYTE	bEnable;
	BYTE	bCDV;
	BYTE	bXCD;
}CODE11_PARAMS, *PCODE11_PARAMS;

typedef struct _CODE39_PARAMS{
	BYTE	bEnable;
	BYTE	bCDV;
	BYTE	bXCD;
	BYTE	bFullASCII;
}CODE39_PARAMS, *PCODE39_PARAMS;

typedef struct _CODE128_PARAMS{
	BYTE	bEnable;
	BYTE	bGs1_128;
	BYTE	bIsbt128;
}CODE128_PARAMS, *PCODE128_PARAMS;

typedef struct _UPCA_PARAMS{
	BYTE	bEnable;
	BYTE	bXNum;
	BYTE	bXCD;
	BYTE	bAddOn;
	BYTE	bUPCA_AS_EAN13;
}UPCA_PARAMS, *PUPCA_PARAMS;

typedef struct _UPCE_PARAMS{
	BYTE	bEnable;
	BYTE	bXNum;
	BYTE	bXCD;	
	BYTE	bUPCE_AS_UPCA;
}UPCE_PARAMS, *PUPCE_PARAMS;

typedef struct _EAN8_PARAMS{
	BYTE	bEnable;
	BYTE	bXCD;	
	BYTE	bEAN8_AS_EAN13;
}EAN8_PARAMS, *PEAN8_PARAMS;

typedef struct _EAN13_PARAMS{
	BYTE	bEnable;
	BYTE	bXCD;
	BYTE	bAddOn;
	BYTE	bISxN;
}EAN13_PARAMS, *PEAN13_PARAMS;

typedef struct _GS1COMPOSITE_PARAMS{
	BYTE	bEnable;
	BYTE	bCC_C;
}GS1COMPOSITE_PARAMS, *PGS1COMPOSITE_PARAMS;

typedef struct _GS1DATABAR_PARAMS{
	BYTE	bEnable;
	BYTE	bGS1LIM;
	BYTE	bGS1EXP;
}GS1DATABAR_PARAMS, *PGS1DATABAR_PARAMS;

typedef struct _INT25_PARAMS{
	BYTE	bEnable;
	BYTE	bCDV;
	BYTE	bXCD;
}INT25_PARAMS, *PINT25_PARAMS;

typedef struct _MSI_PARAMS{
	BYTE	bEnable;
	BYTE	bCDV;
	BYTE	bXCD;
}MSI_PARAMS, *PMSI_PARAMS;

typedef struct _PLESSEY_PARAMS{
	BYTE	bEnable;
	BYTE	bXCD;
}PLESSEY_PARAMS, *PPLESSEY_PARAMS;

typedef struct _POSTNET_PARAMS{
	BYTE	bEnable;
	BYTE	bXCD;
}POSTNET_PARAMS, *PPOSTNET_PARAMS;

typedef struct _STANDARD2OF5_PARAMS{
	BYTE	bEnable;
	BYTE	bCDV;
	BYTE	bXCD;
}STANDARD2OF5_PARAMS, *PSTANDARD2OF5_PARAMS;

typedef struct _TELEPEN_PARAMS{
	BYTE	bEnable;
	BYTE	bNumeric;
}TELEPEN_PARAMS, *PTELEPEN_PARAMS;

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

	LRSCANNER_API BOOL LRSCAN_Open();
	LRSCANNER_API BOOL LRSCAN_Close();
	LRSCANNER_API BOOL LRSCAN_Read();
	LRSCANNER_API BOOL LRSCAN_ReadCancel();
	LRSCANNER_API BOOL LRSCAN_GetScanData(TCHAR *pszBarType, TCHAR *pszBarData);
	LRSCANNER_API BOOL LRSCAN_GetVersionInfo(TCHAR* pszVersion);

	LRSCANNER_API BOOL LRSCAN_SetSymbologyAll();
	LRSCANNER_API BOOL LRSCAN_SetSymbologyDefault();
	LRSCANNER_API BOOL LRSCAN_SetSymbology(PDECODER pSym);
	LRSCANNER_API BOOL LRSCAN_GetSymbology(PDECODER pSym);	
	LRSCANNER_API BOOL LRSCAN_SetOption(PDECODER_PARAMS pOption);
	LRSCANNER_API BOOL LRSCAN_GetOption(PDECODER_PARAMS pOption);

	LRSCANNER_API BOOL LRSCAN_SetCODABAR(PCODABAR_PARAMS pCodabar);
	LRSCANNER_API BOOL LRSCAN_GetCODABAR(PCODABAR_PARAMS pCodabar);
	LRSCANNER_API BOOL LRSCAN_SetCODABLOCK(PCODABLOCK_PARAMS pCodablock);
	LRSCANNER_API BOOL LRSCAN_GetCODABLOCK(PCODABLOCK_PARAMS pCodablock);
	LRSCANNER_API BOOL LRSCAN_SetCODE11(PCODE11_PARAMS pCode11);
	LRSCANNER_API BOOL LRSCAN_GetCODE11(PCODE11_PARAMS pCode11);
	LRSCANNER_API BOOL LRSCAN_SetCODE39(PCODE39_PARAMS pCode39);
	LRSCANNER_API BOOL LRSCAN_GetCODE39(PCODE39_PARAMS pCode39);
	LRSCANNER_API BOOL LRSCAN_SetCODE128(PCODE128_PARAMS pCode128);
	LRSCANNER_API BOOL LRSCAN_GetCODE128(PCODE128_PARAMS pCode128);
	LRSCANNER_API BOOL LRSCAN_SetUPCA(PUPCA_PARAMS pUpca);
	LRSCANNER_API BOOL LRSCAN_GetUPCA(PUPCA_PARAMS pUpca);
	LRSCANNER_API BOOL LRSCAN_SetUPCE(PUPCE_PARAMS pUpce);
	LRSCANNER_API BOOL LRSCAN_GetUPCE(PUPCE_PARAMS pUpce);
	LRSCANNER_API BOOL LRSCAN_SetEAN8(PEAN8_PARAMS pEan8);
	LRSCANNER_API BOOL LRSCAN_GetEAN8(PEAN8_PARAMS pEan8);
	LRSCANNER_API BOOL LRSCAN_SetEAN13(PEAN13_PARAMS pEan13);
	LRSCANNER_API BOOL LRSCAN_GetEAN13(PEAN13_PARAMS pEan13);
	LRSCANNER_API BOOL LRSCAN_SetGS1COMPOSITE(PGS1COMPOSITE_PARAMS pGs1Composite);
	LRSCANNER_API BOOL LRSCAN_GetGS1COMPOSITE(PGS1COMPOSITE_PARAMS pGs1Composite);
	LRSCANNER_API BOOL LRSCAN_SetGS1DATABAR(PGS1DATABAR_PARAMS pGs1Databar);
	LRSCANNER_API BOOL LRSCAN_GetGS1DATABAR(PGS1DATABAR_PARAMS pGs1Databar);
	LRSCANNER_API BOOL LRSCAN_SetINT25(PINT25_PARAMS pInt25);
	LRSCANNER_API BOOL LRSCAN_GetINT25(PINT25_PARAMS pInt25);
	LRSCANNER_API BOOL LRSCAN_SetMSI(PMSI_PARAMS pMsi);
	LRSCANNER_API BOOL LRSCAN_GetMSI(PMSI_PARAMS pMsi);
	LRSCANNER_API BOOL LRSCAN_SetPLESSEY(PPLESSEY_PARAMS pPlessey);
	LRSCANNER_API BOOL LRSCAN_GetPLESSEY(PPLESSEY_PARAMS pPlessey);
	LRSCANNER_API BOOL LRSCAN_SetPOSTNET(PPOSTNET_PARAMS pPostNet);
	LRSCANNER_API BOOL LRSCAN_GetPOSTNET(PPOSTNET_PARAMS pPostNet);
	LRSCANNER_API BOOL LRSCAN_SetSTANDARD2OF5(PSTANDARD2OF5_PARAMS pStandard2of5);
	LRSCANNER_API BOOL LRSCAN_GetSTANDARD2OF5(PSTANDARD2OF5_PARAMS pStandard2of5);
	LRSCANNER_API BOOL LRSCAN_SetTELEPEN(PTELEPEN_PARAMS pTelepen);
	LRSCANNER_API BOOL LRSCAN_GetTELEPEN(PTELEPEN_PARAMS pTelepen);
	LRSCANNER_API SCAN_DEVICE_TYPE LRSCAN_GetDeviceType();

#ifdef __cplusplus
}
#endif // __cplusplus