'********************************************************************
'created	:	2011/10/18
'file base	: 	ImagerTestVB.exe
'
'file ext	:	vb
'author		:	Dong-Hyun Eum & Eun-Taek Lee
'
'purpose	:	Imager VB Demo Program
'Report		:	2012. 01. 13 [01/13/2011 vision7901] v1.0.0 - Release Version
'*********************************************************************/
Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports System.Runtime.InteropServices
Imports Microsoft.Win32
Imports System.Threading
Imports System.Reflection
Imports System.IO
Imports ImagerNet

Public Class ImagerTestVB

    Private m_Imager As Imager
    Private m_DecoderParams As DECODER_PARAMS

    Public m_bResult As Boolean = False
    Public m_bSyncMode As Boolean = False
    Public m_bWinCE As Boolean = False

    Public m_strVerInfo As String

    Public Const VK_F22 As Long = &H85 'F22(WinCE) 
    Public Const VK_F14 As Long = &H7D 'F14(WM)
    Private m_nHotKeyCE As UInt32
    Private m_nHotKeyWM As UInt32

    Private m_DeviceType As SCAN_DEVICE_TYPE

    Private Sub ImagerTestVB_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        m_Imager = New Imager()
        AddHandler m_Imager.ImagerDataEvent, AddressOf Me.OnScanRead

        'Get Device Type
        m_DeviceType = m_Imager.GetDeviceType()

        'OS Type
        If m_DeviceType = ImagerNet.SCAN_DEVICE_TYPE.DEVICE_M3SMART_CE Or m_DeviceType = ImagerNet.SCAN_DEVICE_TYPE.DEVICE_M3GREEN Or m_DeviceType = ImagerNet.SCAN_DEVICE_TYPE.DEVICE_M3T Or m_DeviceType = ImagerNet.SCAN_DEVICE_TYPE.DEVICE_M3POS Or m_DeviceType = ImagerNet.SCAN_DEVICE_TYPE.DEVICE_M3ORANGEPLUS_CE Or m_DeviceType = ImagerNet.SCAN_DEVICE_TYPE.DEVICE_M3UL10_CE Or m_DeviceType = ImagerNet.SCAN_DEVICE_TYPE.DEVICE_M3TPLUS_CE Or m_DeviceType = ImagerNet.SCAN_DEVICE_TYPE.DEVICE_M3BLACK_CE Then
            m_bWinCE = True
        End If

        'Scanner Open
        m_Imager.Open()

        m_nHotKeyCE = UInt32.Parse(VK_F22)
        m_nHotKeyWM = UInt32.Parse(VK_F14)

        If m_bWinCE = True Then
            m_Imager.RegHotKey(1, m_nHotKeyCE, m_bSyncMode)
        Else
            m_Imager.RegHotKey(1, m_nHotKeyWM, m_bSyncMode)
        End If

        m_Imager.SetSymbologyAll()

        If (m_DeviceType = SCAN_DEVICE_TYPE.DEVICE_M3BLACK) Then
            BN_IQIMAING.Enabled = False
        End If
    End Sub

    Private Sub OnScanRead(ByVal sender As System.Object, ByVal e As ImagerDataArgs)
        If e.ScanData <> "" Then
            LB_TYPE.Text = e.ScanType
            TB_DATA.Text = e.ScanData
        End If
    End Sub

    Private Sub ImagerTestVB_Closing(ByVal sender As System.Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
        Dim i As Integer
        Dim bResult As Boolean

        m_Imager.UnRegHotKey(1)

        For i = 0 To 3
            bResult = m_Imager.Close()
            Thread.Sleep(300)
            If bResult = True Then
                Exit For
            End If

            i = i + 1
        Next

    End Sub

    Private Sub BN_SCAN_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_SCAN.Click
        m_Imager.Read()
    End Sub

    Private Sub BN_SCANCANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_SCANCANCEL.Click
        m_Imager.ReadCancel()
    End Sub

    Private Sub BN_SYM_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_SYM.Click
        'Disable Scan Key
        m_Imager.ReadCancel()
        m_Imager.UnRegHotKey(1)

        Dim Symbology As New FSYMBOLOGY()

        Symbology.ShowDialog()

        ' Enable Scan Key
        If m_bWinCE = True Then
            m_Imager.RegHotKey(1, m_nHotKeyCE, m_bSyncMode)
        Else
            m_Imager.RegHotKey(1, m_nHotKeyWM, m_bSyncMode)
        End If
    End Sub

    Private Sub BN_SCANOPTION_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_SCANOPTION.Click
        REM Disable Scan Key
        m_Imager.ReadCancel()
        m_Imager.UnRegHotKey(1)

        Dim ScanOption As New FSCANOPTION()

        ScanOption.m_bSyncMode = m_bSyncMode

        If ScanOption.ShowDialog() = DialogResult.OK Then
            m_bSyncMode = ScanOption.m_bSyncMode
        End If

        'Enable Scan Key
        If m_bWinCE = True Then
            m_Imager.RegHotKey(1, m_nHotKeyCE, m_bSyncMode)
        Else
            m_Imager.RegHotKey(1, m_nHotKeyWM, m_bSyncMode)
        End If
    End Sub

    Private Sub BN_CAMTEST_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_CAMTEST.Click
        m_Imager.ReadCancel()

        Dim CamTest As New FCAMTEST()

        m_Imager.CAMInit(CamTest.PIC_IMAGE.Handle)
        CamTest.ShowDialog()
        m_Imager.CAMUnInit()
    End Sub

    Private Sub BN_IQIMAING_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_IQIMAING.Click
        m_Imager.ReadCancel()

        Dim IQTest As New FIQTEST()

        RemoveHandler m_Imager.ImagerDataEvent, AddressOf Me.OnScanRead
        AddHandler m_Imager.ImagerDataEvent, AddressOf IQTest.OnIQImaging

        m_Imager.IQInit(IQTest.PIC_IQ_IMAGE.Handle)
        IQTest.ShowDialog()
        m_Imager.IQUnInit()

        RemoveHandler m_Imager.ImagerDataEvent, AddressOf IQTest.OnIQImaging
        AddHandler m_Imager.ImagerDataEvent, AddressOf Me.OnScanRead

    End Sub

    Private Sub BN_NEW_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_NEW.Click
        m_Imager.ReadCancel()

        Dim NewForm As New FTEST()

        RemoveHandler m_Imager.ImagerDataEvent, AddressOf Me.OnScanRead

        NewForm.ShowDialog()

        AddHandler m_Imager.ImagerDataEvent, AddressOf Me.OnScanRead

    End Sub

    Private Sub BN_INFO_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_INFO.Click
        'Disable Scan Key
        m_Imager.ReadCancel()
        m_Imager.UnRegHotKey(1)

        Dim AboutDlg As New FABOUT()

        AboutDlg.m_strVersion = m_Imager.GetVersionInfo()

        AboutDlg.ShowDialog()

        'Enable Scan Key
        If m_bWinCE = True Then
            m_Imager.RegHotKey(1, m_nHotKeyCE, m_bSyncMode)
        Else
            m_Imager.RegHotKey(1, m_nHotKeyWM, m_bSyncMode)
        End If
    End Sub

    Private Sub BN_CLOSE_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_CLOSE.Click
        m_Imager.ReadCancel()

        Close()

        Application.Exit()
    End Sub
End Class
