﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports ImagerNet



Public Class FSYMBOLOGY


    Private m_Imager As New Imager
    Private m_Decoder As New ImagerNet.DECODER

    Private m_Aztec As New AZTEC_PARAMS
    Private m_Codabar As New CODABAR_PARAMS
    Private m_Code11 As New CODE11_PARAMS
    Private m_Code128 As New CODE128_PARAMS
    Private m_Code39 As New CODE39_PARAMS
    Private m_Code49 As New CODE49_PARAMS
    Private m_Code93 As New CODE93_PARAMS
    Private m_Composite As New COMPOSITE_PARAMS
    Private m_Datamatrix As New DATAMATRIX_PARAMS
    Private m_Ean8 As New EAN8_PARAMS
    Private m_Ean13 As New EAN13_PARAMS
    Private m_Int25 As New INT25_PARAMS
    Private m_Maxicode As New MAXICODE_PARAMS
    Private m_Micropdf As New MICROPDF_PARAMS
    Private m_Ocr As New OCR_PARAMS
    Private m_Pdf417 As New PDF417_PARAMS
    Private m_Postnet As New POSTNET_PARAMS
    Private m_Qr As New QR_PARAMS
    Private m_Rss As New RSS_PARAMS
    Private m_Upca As New UPCA_PARAMS
    Private m_Upce As New UPCE_PARAMS
    Private m_Iata25 As New IATA25_PARAMS
    Private m_Codablock As New CODABLOCK_PARAMS
    Private m_Planet As New PLANET_PARAMS
    Private m_Msi As New MSI_PARAMS
    Private m_Strt25 As New STRT25_PARAMS
    Private m_Matrix25 As New MATRIX25_PARAMS
    Private m_Plessey As New PLESSEY_PARAMS
    Private m_Chinapost As New CHINAPOST_PARAMS
    Private m_Koreapost As New KOREAPOST_PARAMS
    Private m_Telepen As New TELEPEN_PARAMS
    Private m_Code16k As New CODE16K_PARAMS
    Private m_Posicode As New POSICODE_PARAMS


    Private Const AZTEC As Integer = 0
    Private Const CODABAR As Integer = 1
    Private Const CODE11 As Integer = 2
    Private Const CODE128 As Integer = 3
    Private Const CODE39 As Integer = 4
    Private Const CODE49 As Integer = 5
    Private Const CODE93 As Integer = 6
    Private Const COMPOSITE As Integer = 7
    Private Const DATAMATRIX As Integer = 8
    Private Const EAN8 As Integer = 9
    Private Const EAN13 As Integer = 10
    Private Const INT25 As Integer = 11
    Private Const MAXICODE As Integer = 12
    Private Const MICROPDF As Integer = 13
    Private Const OCR As Integer = 14
    Private Const PDF417 As Integer = 15
    Private Const POSTNET As Integer = 16
    Private Const QR As Integer = 17
    Private Const RSS As Integer = 18
    Private Const UPCA As Integer = 19
    Private Const UPCE As Integer = 20
    Private Const ISBT As Integer = 21
    Private Const BPO As Integer = 22
    Private Const CANPOST As Integer = 23
    Private Const AUSPOST As Integer = 24
    Private Const IATA25 As Integer = 25
    Private Const CODABLOCK As Integer = 26
    Private Const JAPOST As Integer = 27
    Private Const PLANET As Integer = 28
    Private Const DUTCHPOST As Integer = 29
    Private Const MSI As Integer = 30
    Private Const TLCODE39 As Integer = 31
    Private Const STRT25 As Integer = 32
    Private Const MATRIX25 As Integer = 33
    Private Const PLESSEY As Integer = 34
    Private Const CHINAPOST As Integer = 35
    Private Const KOREAPOST As Integer = 36
    Private Const TELEPEN As Integer = 37
    Private Const CODE16K As Integer = 38
    Private Const POSICODE As Integer = 39
    Private Const COUPONCODE As Integer = 40
    Private Const USBS4CB As Integer = 41
    Private Const IDTAG As Integer = 42
    Private Const LABEL As Integer = 43
    Private Const GS1_128 As Integer = 44
    Private Const HANXIN As Integer = 45
    Private Const GRIDMATRIX As Integer = 46

    Dim BARCODE_TYPE() As String = {"AZTEC", "CODABAR", "CODE11", "CODE128", "CODE39", "CODE49", "CODE93", "COMPOSITE", "DATAMATRIX", "EAN-8", "EAN-13", "INT25", "MAXICODE", "MICROPDF", "OCR", "PDF417", "POSTNET", "QR", "RSS", "UPC-A", "UPC-E", "ISBT", "BPO", "CANAPOST", "AUSPOST", "IATA25", "CODABLOCK", "JAPOST", "PLANET", "DUTCHPOST", "MSI", "TLCODE39", "STRT25", "MATRIX25", "PLESSEY", "CHINAPOST", "KOREAPOST", "TELEPEN", "CODE16K", "POSICODE", "COUPONCODE", "USPS4CB", "IDTAG", "LABEL", "GS1-128", "HANXIN", "GRIDMATRIX"}
    Dim BARCODE_ENABLED() As Boolean = {True, True, True, True, True, False, True, True, True, True, True, True, True, True, False, True, True, True, True, True, True, True, True, False, True, True, False, False, True, True, True, True, False, True, False, True, True, False, False, True, True, True, True, False, True, False, False}

    Dim BARCODE_ENABLE(47) As Boolean

    Dim Temp As Integer = -1
    Dim Temp_0 As Integer = 0

    Public BarcodeItem As ListViewItem



    Private Sub FSYMBOLOGY_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Dim i As Integer

        BarcodeItem = New ListViewItem()

        m_Imager.GetSymbology(m_Decoder)

        SetCheckBox()

        For i = 0 To 46
            BarcodeItem = New ListViewItem()
            BarcodeItem.Checked = BARCODE_ENABLE(i)
            BarcodeItem.SubItems.Add(BARCODE_TYPE(i))
            If (BARCODE_ENABLED(i) = False) Then
                BarcodeItem.ForeColor = Color.LightGray
            End If

            Me.LV_SYMLIST.Items.Add(BarcodeItem)
        Next

        TB_MINLEN.Text = Temp_0.ToString()
        TB_MAXLEN.Text = Temp_0.ToString()

        LB_MIN.Enabled = False
        LB_MAX.Enabled = False
        TB_MINLEN.Enabled = False
        TB_MAXLEN.Enabled = False
        BTN_APPLY.Enabled = False
        BTN_PARAM.Enabled = False

    End Sub


    Public Sub SetCheckBox()

        m_Imager.GetSymbology(m_Decoder)

        BARCODE_ENABLE(0) = m_Decoder.bAZTEC
        BARCODE_ENABLE(1) = m_Decoder.bCODABAR
        BARCODE_ENABLE(2) = m_Decoder.bCODE11
        BARCODE_ENABLE(3) = m_Decoder.bCODE128
        BARCODE_ENABLE(4) = m_Decoder.bCODE39
        BARCODE_ENABLE(5) = m_Decoder.bCODE49
        BARCODE_ENABLE(6) = m_Decoder.bCODE93
        BARCODE_ENABLE(7) = m_Decoder.bCOMPOSITE
        BARCODE_ENABLE(8) = m_Decoder.bDATAMATRIX
        BARCODE_ENABLE(9) = m_Decoder.bEAN8
        BARCODE_ENABLE(10) = m_Decoder.bEAN13
        BARCODE_ENABLE(11) = m_Decoder.bINT25
        BARCODE_ENABLE(12) = m_Decoder.bMAXICODE
        BARCODE_ENABLE(13) = m_Decoder.bMICROPDF
        BARCODE_ENABLE(14) = m_Decoder.bOCR
        BARCODE_ENABLE(15) = m_Decoder.bPDF417
        BARCODE_ENABLE(16) = m_Decoder.bPOSTNET
        BARCODE_ENABLE(17) = m_Decoder.bQR
        BARCODE_ENABLE(18) = m_Decoder.bRSS
        BARCODE_ENABLE(19) = m_Decoder.bUPCA
        BARCODE_ENABLE(20) = m_Decoder.bUPCE
        BARCODE_ENABLE(21) = m_Decoder.bISBT
        BARCODE_ENABLE(22) = m_Decoder.bBPO
        BARCODE_ENABLE(23) = m_Decoder.bCANPOST
        BARCODE_ENABLE(24) = m_Decoder.bAUSPOST
        BARCODE_ENABLE(25) = m_Decoder.bIATA25
        BARCODE_ENABLE(26) = m_Decoder.bCODABLOCK
        BARCODE_ENABLE(27) = m_Decoder.bJAPOST
        BARCODE_ENABLE(28) = m_Decoder.bPLANET
        BARCODE_ENABLE(29) = m_Decoder.bDUTCHPOST
        BARCODE_ENABLE(30) = m_Decoder.bMSI
        BARCODE_ENABLE(31) = m_Decoder.bTLCODE39
        BARCODE_ENABLE(32) = m_Decoder.bSTRT25
        BARCODE_ENABLE(33) = m_Decoder.bMATRIX25
        BARCODE_ENABLE(34) = m_Decoder.bPLESSEY
        BARCODE_ENABLE(35) = m_Decoder.bCHINAPOST
        BARCODE_ENABLE(36) = m_Decoder.bKOREAPOST
        BARCODE_ENABLE(37) = m_Decoder.bTELEPEN
        BARCODE_ENABLE(38) = m_Decoder.bCODE16K
        BARCODE_ENABLE(39) = m_Decoder.bPOSICODE
        BARCODE_ENABLE(40) = m_Decoder.bCOUPONCODE
        BARCODE_ENABLE(41) = m_Decoder.bUSPS4CB
        BARCODE_ENABLE(42) = m_Decoder.bIDTAG
        BARCODE_ENABLE(43) = m_Decoder.bLABEL
        BARCODE_ENABLE(44) = m_Decoder.bGS1_128
        BARCODE_ENABLE(45) = m_Decoder.bHANXIN
        BARCODE_ENABLE(46) = m_Decoder.bGRIDMATRIX

    End Sub
         
    Private Sub LV_SYMLIST_ItemActivate(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LV_SYMLIST.ItemActivate

        Select Case LV_SYMLIST.FocusedItem.Index
            Case AZTEC, CODE128, CODE49, CODE93, DATAMATRIX, MAXICODE, MICROPDF, PDF417, QR, IATA25, CODABLOCK, STRT25, MATRIX25, PLESSEY, CHINAPOST, KOREAPOST, CODE16K
                LB_MIN.Enabled = True
                LB_MAX.Enabled = True
                TB_MINLEN.Enabled = True
                TB_MAXLEN.Enabled = True
                BTN_APPLY.Enabled = True
                BTN_PARAM.Enabled = False

            Case CODABAR, CODE11, CODE39, COMPOSITE, INT25, RSS, MSI, TELEPEN, POSICODE
                LB_MIN.Enabled = True
                LB_MAX.Enabled = True
                TB_MINLEN.Enabled = True
                TB_MAXLEN.Enabled = True
                BTN_APPLY.Enabled = True
                BTN_PARAM.Enabled = True

            Case EAN8, EAN13, POSTNET, UPCA, UPCE, PLANET, OCR
                LB_MIN.Enabled = False
                LB_MAX.Enabled = False
                TB_MINLEN.Enabled = False
                TB_MAXLEN.Enabled = False
                BTN_APPLY.Enabled = False
                BTN_PARAM.Enabled = True

            Case ISBT, BPO, CANPOST, AUSPOST, JAPOST, DUTCHPOST, TLCODE39, COUPONCODE, USBS4CB, IDTAG, LABEL, GS1_128, HANXIN, GRIDMATRIX
                LB_MIN.Enabled = False
                LB_MAX.Enabled = False
                TB_MINLEN.Enabled = False
                TB_MAXLEN.Enabled = False
                BTN_APPLY.Enabled = False
                BTN_PARAM.Enabled = False

        End Select


        Select Case LV_SYMLIST.FocusedItem.Index
            Case AZTEC
                If m_Imager.GetAZTEC(m_Aztec) = False Then
                    MessageBox.Show("GetAZTEC()")
                End If

                TB_MINLEN.Text = m_Aztec.nMinLen.ToString()
                TB_MAXLEN.Text = m_Aztec.nMaxLen.ToString()


            Case CODABAR
                If m_Imager.GetCODABAR(m_Codabar) = False Then
                    MessageBox.Show("GetCODABAR()")
                End If

                TB_MINLEN.Text = m_Codabar.nMinLen.ToString()
                TB_MAXLEN.Text = m_Codabar.nMaxLen.ToString()


            Case CODE11
                If m_Imager.GetCODE11(m_Code11) = False Then
                    MessageBox.Show("GetCODE11()")
                End If

                TB_MINLEN.Text = m_Code11.nMinLen.ToString()
                TB_MAXLEN.Text = m_Code11.nMaxLen.ToString()


            Case CODE128
                If m_Imager.GetCODE128(m_Code128) = False Then
                    MessageBox.Show("GetCODE128()")
                End If

                TB_MINLEN.Text = m_Code128.nMinLen.ToString()
                TB_MAXLEN.Text = m_Code128.nMaxLen.ToString()


            Case CODE39
                If m_Imager.GetCODE39(m_Code39) = False Then
                    MessageBox.Show("GetCODE39()")
                End If

                TB_MINLEN.Text = m_Code39.nMinLen.ToString()
                TB_MAXLEN.Text = m_Code39.nMaxLen.ToString()


            Case CODE49
                If m_Imager.GetCODE49(m_Code49) = False Then
                    MessageBox.Show("GetCODE49()")
                End If

                TB_MINLEN.Text = m_Code49.nMinLen.ToString()
                TB_MAXLEN.Text = m_Code49.nMaxLen.ToString()


            Case CODE93
                If m_Imager.GetCODE93(m_Code93) = False Then
                    MessageBox.Show("GetCODE93()")
                End If

                TB_MINLEN.Text = m_Code93.nMinLen.ToString()
                TB_MAXLEN.Text = m_Code93.nMaxLen.ToString()


            Case COMPOSITE
                If m_Imager.GetCOMPOSITE(m_Composite) = False Then
                    MessageBox.Show("GetCOMPOSITE()")
                End If

                TB_MINLEN.Text = m_Composite.nMinLen.ToString()
                TB_MAXLEN.Text = m_Composite.nMaxLen.ToString()


            Case DATAMATRIX
                If m_Imager.GetDATAMATRIX(m_Datamatrix) = False Then
                    MessageBox.Show("GetDATAMATRIX()")
                End If

                TB_MINLEN.Text = m_Datamatrix.nMinLen.ToString()
                TB_MAXLEN.Text = m_Datamatrix.nMaxLen.ToString()

            Case INT25
                If m_Imager.GetINT25(m_Int25) = False Then
                    MessageBox.Show("GetINT25()")
                End If

                TB_MINLEN.Text = m_Int25.nMinLen.ToString()
                TB_MAXLEN.Text = m_Int25.nMaxLen.ToString()

            Case MAXICODE
                If m_Imager.GetMAXICODE(m_Maxicode) = False Then
                    MessageBox.Show("GetMAXICODE()")
                End If

                TB_MINLEN.Text = m_Maxicode.nMinLen.ToString()
                TB_MAXLEN.Text = m_Maxicode.nMaxLen.ToString()

            Case MICROPDF
                If m_Imager.GetMICROPDF(m_Micropdf) = False Then
                    MessageBox.Show("GetMICROPDF()")
                End If

                TB_MINLEN.Text = m_Maxicode.nMinLen.ToString()
                TB_MAXLEN.Text = m_Maxicode.nMaxLen.ToString()

            Case PDF417
                If m_Imager.GetPDF417(m_Pdf417) = False Then
                    MessageBox.Show("GetPDF417()")
                End If

                TB_MINLEN.Text = m_Pdf417.nMinLen.ToString()
                TB_MAXLEN.Text = m_Pdf417.nMaxLen.ToString()

            Case QR
                If m_Imager.GetQR(m_Qr) = False Then
                    MessageBox.Show("GetQR()")
                End If

                TB_MINLEN.Text = m_Qr.nMinLen.ToString()
                TB_MAXLEN.Text = m_Qr.nMaxLen.ToString()

            Case RSS
                If m_Imager.GetRSS(m_Rss) = False Then
                    MessageBox.Show("GetRSS()")
                End If

                TB_MINLEN.Text = m_Rss.nMinLen.ToString()
                TB_MAXLEN.Text = m_Rss.nMaxLen.ToString()

            Case IATA25
                If m_Imager.GetIATA25(m_Iata25) = False Then
                    MessageBox.Show("GetIATA25()")
                End If

                TB_MINLEN.Text = m_Iata25.nMinLen.ToString()
                TB_MAXLEN.Text = m_Iata25.nMaxLen.ToString()

            Case CODABLOCK
                If m_Imager.GetCODABLOCK(m_Codablock) = False Then
                    MessageBox.Show("GetCODABLOCK()")
                End If

                TB_MINLEN.Text = m_Codablock.nMinLen.ToString()
                TB_MAXLEN.Text = m_Codablock.nMaxLen.ToString()

            Case MSI
                If m_Imager.GetMSI(m_Msi) = False Then
                    MessageBox.Show("GetMSI()")
                End If

                TB_MINLEN.Text = m_Msi.nMinLen.ToString()
                TB_MAXLEN.Text = m_Msi.nMaxLen.ToString()

            Case STRT25
                If m_Imager.GetSTRT25(m_Strt25) = False Then
                    MessageBox.Show("GetSTRT25()")
                End If

                TB_MINLEN.Text = m_Strt25.nMinLen.ToString()
                TB_MAXLEN.Text = m_Strt25.nMaxLen.ToString()

            Case MATRIX25
                If m_Imager.GetMATRIX25(m_Matrix25) = False Then
                    MessageBox.Show("GetMATRIX25()")
                End If

                TB_MINLEN.Text = m_Matrix25.nMinLen.ToString()
                TB_MAXLEN.Text = m_Matrix25.nMaxLen.ToString()

            Case PLESSEY
                If m_Imager.GetPLESSEY(m_Plessey) = False Then
                    MessageBox.Show("GetPLESSEY()")
                End If

                TB_MINLEN.Text = m_Plessey.nMinLen.ToString()
                TB_MAXLEN.Text = m_Plessey.nMaxLen.ToString()

            Case CHINAPOST
                If m_Imager.GetCHINAPOST(m_Chinapost) = False Then
                    MessageBox.Show("GetCHINAPOST()")
                End If

                TB_MINLEN.Text = m_Chinapost.nMinLen.ToString()
                TB_MAXLEN.Text = m_Chinapost.nMaxLen.ToString()

            Case KOREAPOST
                If m_Imager.GetKOREAPOST(m_Koreapost) = False Then
                    MessageBox.Show("GetKOREAPOST()")
                End If

                TB_MINLEN.Text = m_Koreapost.nMinLen.ToString()
                TB_MAXLEN.Text = m_Koreapost.nMaxLen.ToString()

            Case TELEPEN
                If m_Imager.GetTELEPEN(m_Telepen) = False Then
                    MessageBox.Show("GetTELEPEN()")
                End If

                TB_MINLEN.Text = m_Telepen.nMinLen.ToString()
                TB_MAXLEN.Text = m_Telepen.nMaxLen.ToString()

            Case CODE16K
                If m_Imager.GetCODE16K(m_Code16k) = False Then
                    MessageBox.Show("GetCODE16K()")
                End If

                TB_MINLEN.Text = m_Code16k.nMinLen.ToString()
                TB_MAXLEN.Text = m_Code16k.nMaxLen.ToString()

            Case POSICODE
                If m_Imager.GetPOSICODE(m_Posicode) = False Then
                    MessageBox.Show("GetPOSICODE()")
                End If

                TB_MINLEN.Text = m_Posicode.nMinLen.ToString()
                TB_MAXLEN.Text = m_Posicode.nMaxLen.ToString()

            Case OCR, EAN8, EAN13, POSTNET, UPCA, UPCE, PLANET, ISBT, BPO, CANPOST, AUSPOST, JAPOST, DUTCHPOST, TLCODE39, COUPONCODE, USBS4CB, IDTAG, LABEL, GS1_128, HANXIN, GRIDMATRIX
                TB_MINLEN.Text = Temp.ToString()
                TB_MAXLEN.Text = Temp.ToString()

        End Select

        If LV_SYMLIST.FocusedItem.Checked = True Then
            LV_SYMLIST.FocusedItem.Checked = False
        Else
            LV_SYMLIST.FocusedItem.Checked = True
        End If

    End Sub

    Private Sub BTN_ALL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_ALL.Click

        m_Imager.SetSymbologyAll()

        SetCheckBox()

        Dim i As Integer

        For i = 0 To 46
            If BARCODE_ENABLE(i) = True Then
                LV_SYMLIST.Items(i).Checked = True
            Else
                LV_SYMLIST.Items(i).Checked = False
            End If
        Next

    End Sub

    Private Sub BTN_DAFAULT_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_DAFAULT.Click

        m_Imager.SetSymbologyDefault()

        SetCheckBox()

        Dim i As Integer

        For i = 0 To 46
            If BARCODE_ENABLE(i) = True Then
                LV_SYMLIST.Items(i).Checked = True
            Else
                LV_SYMLIST.Items(i).Checked = False
            End If
        Next

    End Sub

    Private Sub OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK.Click

        m_Decoder.bAZTEC = LV_SYMLIST.Items(0).Checked
        m_Decoder.bCODABAR = LV_SYMLIST.Items(1).Checked
        m_Decoder.bCODE11 = LV_SYMLIST.Items(2).Checked
        m_Decoder.bCODE128 = LV_SYMLIST.Items(3).Checked
        m_Decoder.bCODE39 = LV_SYMLIST.Items(4).Checked
        m_Decoder.bCODE49 = LV_SYMLIST.Items(5).Checked
        m_Decoder.bCODE93 = LV_SYMLIST.Items(6).Checked
        m_Decoder.bCOMPOSITE = LV_SYMLIST.Items(7).Checked
        m_Decoder.bDATAMATRIX = LV_SYMLIST.Items(8).Checked
        m_Decoder.bEAN8 = LV_SYMLIST.Items(9).Checked
        m_Decoder.bEAN13 = LV_SYMLIST.Items(10).Checked
        m_Decoder.bINT25 = LV_SYMLIST.Items(11).Checked
        m_Decoder.bMAXICODE = LV_SYMLIST.Items(12).Checked
        m_Decoder.bMICROPDF = LV_SYMLIST.Items(13).Checked
        m_Decoder.bOCR = LV_SYMLIST.Items(14).Checked
        m_Decoder.bPDF417 = LV_SYMLIST.Items(15).Checked
        m_Decoder.bPOSTNET = LV_SYMLIST.Items(16).Checked
        m_Decoder.bQR = LV_SYMLIST.Items(17).Checked
        m_Decoder.bRSS = LV_SYMLIST.Items(18).Checked
        m_Decoder.bUPCA = LV_SYMLIST.Items(19).Checked
        m_Decoder.bUPCE = LV_SYMLIST.Items(20).Checked
        m_Decoder.bISBT = LV_SYMLIST.Items(21).Checked
        m_Decoder.bBPO = LV_SYMLIST.Items(22).Checked
        m_Decoder.bCANPOST = LV_SYMLIST.Items(23).Checked
        m_Decoder.bAUSPOST = LV_SYMLIST.Items(24).Checked
        m_Decoder.bIATA25 = LV_SYMLIST.Items(25).Checked
        m_Decoder.bCODABLOCK = LV_SYMLIST.Items(26).Checked
        m_Decoder.bJAPOST = LV_SYMLIST.Items(27).Checked
        m_Decoder.bPLANET = LV_SYMLIST.Items(28).Checked
        m_Decoder.bDUTCHPOST = LV_SYMLIST.Items(29).Checked
        m_Decoder.bMSI = LV_SYMLIST.Items(30).Checked
        m_Decoder.bTLCODE39 = LV_SYMLIST.Items(31).Checked
        m_Decoder.bSTRT25 = LV_SYMLIST.Items(32).Checked
        m_Decoder.bMATRIX25 = LV_SYMLIST.Items(33).Checked
        m_Decoder.bPLESSEY = LV_SYMLIST.Items(34).Checked
        m_Decoder.bCHINAPOST = LV_SYMLIST.Items(35).Checked
        m_Decoder.bKOREAPOST = LV_SYMLIST.Items(36).Checked
        m_Decoder.bTELEPEN = LV_SYMLIST.Items(37).Checked
        m_Decoder.bCODE16K = LV_SYMLIST.Items(38).Checked
        m_Decoder.bPOSICODE = LV_SYMLIST.Items(39).Checked
        m_Decoder.bCOUPONCODE = LV_SYMLIST.Items(40).Checked
        m_Decoder.bUSPS4CB = LV_SYMLIST.Items(41).Checked
        m_Decoder.bIDTAG = LV_SYMLIST.Items(42).Checked
        m_Decoder.bLABEL = LV_SYMLIST.Items(43).Checked
        m_Decoder.bGS1_128 = LV_SYMLIST.Items(44).Checked
        m_Decoder.bHANXIN = LV_SYMLIST.Items(45).Checked
        m_Decoder.bGRIDMATRIX = LV_SYMLIST.Items(46).Checked

        m_Imager.SetSymbology(m_Decoder)

        Me.DialogResult = Windows.Forms.DialogResult.OK


    End Sub

    Private Sub BTN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub

    Private Sub BTN_APPLY_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_APPLY.Click
        Select Case LV_SYMLIST.FocusedItem.Index
            Case AZTEC
                m_Aztec.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Aztec.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetAZTEC(m_Aztec) = False Then
                    MessageBox.Show("SetAZTEC()")
                End If

            Case CODABAR
                m_Codabar.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Codabar.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetCODABAR(m_Codabar) = False Then
                    MessageBox.Show("SetCODABAR()")
                End If

            Case CODE11
                m_Code11.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Code11.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetCODE11(m_Code11) = False Then
                    MessageBox.Show("SetCODE11()")
                End If

            Case CODE128
                m_Code128.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Code128.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetCODE128(m_Code128) = False Then
                    MessageBox.Show("SetCODE128()")
                End If

            Case CODE39
                m_Code39.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Code39.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetCODE39(m_Code39) = False Then
                    MessageBox.Show("SetCODE39()")
                End If

            Case CODE49
                m_Code49.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Code49.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetCODE49(m_Code49) = False Then
                    MessageBox.Show("SetCODE49()")
                End If

            Case CODE93
                m_Code93.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Code93.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetCODE93(m_Code93) = False Then
                    MessageBox.Show("SetCODE93()")
                End If

            Case COMPOSITE
                m_Composite.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Composite.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetCOMPOSITE(m_Composite) = False Then
                    MessageBox.Show("SetCOMPOSITE()")
                End If

            Case DATAMATRIX
                m_Datamatrix.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Datamatrix.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetDATAMATRIX(m_Datamatrix) = False Then
                    MessageBox.Show("SetDATAMATRIX()")
                End If

            Case INT25
                m_Int25.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Int25.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetINT25(m_Int25) = False Then
                    MessageBox.Show("SetINT25()")
                End If

            Case MAXICODE
                m_Maxicode.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Maxicode.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetMAXICODE(m_Maxicode) = False Then
                    MessageBox.Show("SetMAXICODE()")
                End If

            Case MICROPDF
                m_Micropdf.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Micropdf.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetMICROPDF(m_Micropdf) = False Then
                    MessageBox.Show("SetMICROPDF()")
                End If

            Case PDF417
                m_Pdf417.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Pdf417.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetPDF417(m_Pdf417) = False Then
                    MessageBox.Show("SetPDF417()")
                End If

            Case QR
                m_Qr.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Qr.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetQR(m_Qr) = False Then
                    MessageBox.Show("SetQR()")
                End If

            Case RSS
                m_Rss.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Rss.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetRSS(m_Rss) = False Then
                    MessageBox.Show("SetRSS()")
                End If

            Case IATA25
                m_Iata25.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Iata25.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetIATA25(m_Iata25) = False Then
                    MessageBox.Show("SetIATA25()")
                End If

            Case CODABLOCK
                m_Codablock.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Codablock.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetCODABLOCK(m_Codablock) = False Then
                    MessageBox.Show("SetCODABLOCK()")
                End If

            Case MSI
                m_Msi.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Msi.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetMSI(m_Msi) = False Then
                    MessageBox.Show("SetMSI()")
                End If

            Case STRT25
                m_Strt25.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Strt25.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetSTRT25(m_Strt25) = False Then
                    MessageBox.Show("SetSTRT25()")
                End If

            Case MATRIX25
                m_Matrix25.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Matrix25.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetMATRIX25(m_Matrix25) = False Then
                    MessageBox.Show("SetMATRIX25()")
                End If

            Case PLESSEY
                m_Plessey.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Plessey.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetPLESSEY(m_Plessey) = False Then
                    MessageBox.Show("SetPLESSEY()")
                End If

            Case CHINAPOST
                m_Chinapost.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Chinapost.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetCHINAPOST(m_Chinapost) = False Then
                    MessageBox.Show("SetCHINAPOST()")
                End If

            Case KOREAPOST
                m_Koreapost.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Koreapost.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetKOREAPOST(m_Koreapost) = False Then
                    MessageBox.Show("SetKOREAPOST()")
                End If

            Case TELEPEN
                m_Telepen.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Telepen.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetTELEPEN(m_Telepen) = False Then
                    MessageBox.Show("SetTELEPEN()")
                End If

            Case CODE16K
                m_Code16k.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Code16k.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetCODE16K(m_Code16k) = False Then
                    MessageBox.Show("SetCODE16K()")
                End If

            Case POSICODE
                m_Posicode.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
                m_Posicode.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

                If m_Imager.SetPOSICODE(m_Posicode) = False Then
                    MessageBox.Show("SetPOSICODE()")
                End If
        End Select
 
    End Sub

    Private Sub BTN_PARAM_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_PARAM.Click
        Select Case LV_SYMLIST.FocusedItem.Index
            Case CODABAR
                Dim CodabarDlg As New FCODABAR()
                If CodabarDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(CODABAR).Checked = m_Codabar.bEnable
                End If

            Case CODE11
                Dim Code11Dlg As New FCODE11()
                If Code11Dlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(CODE11).Checked = m_Code11.bEnable
                End If

            Case CODE39
                Dim Code39Dlg As New FCODE39()
                If Code39Dlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(CODE39).Checked = m_Code39.bEnable
                End If

            Case COMPOSITE
                Dim CompositeDlg As New FCOMPOSITE()
                If CompositeDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(COMPOSITE).Checked = m_Composite.bEnable
                End If

            Case EAN13
                Dim Ean13Dlg As New FEAN13()
                If Ean13Dlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(EAN13).Checked = m_Ean13.bEnable
                End If

            Case EAN8
                Dim Ean8Dlg As New FEAN8()
                If Ean8Dlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(EAN8).Checked = m_Ean8.bEnable
                End If

            Case INT25
                Dim Int25Dlg As New FINT25()
                If Int25Dlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(INT25).Checked = m_Int25.bEnable
                End If

            Case MSI
                Dim MsiDlg As New FMSI()
                If MsiDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(MSI).Checked = m_Msi.bEnable
                End If


            Case OCR
                Dim OcrDlg As New FOCR()
                If OcrDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(OCR).Checked = m_Ocr.bEnable
                End If

            Case POSTNET
                Dim PostnetDlg As New FPOSTNET()
                If PostnetDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(POSTNET).Checked = m_Postnet.bEnable
                End If

            Case PLANET
                Dim PlanetDlg As New FPLANET()
                If PlanetDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(PLANET).Checked = m_Planet.bEnable
                End If


            Case POSICODE
                Dim PosicodeDlg As New FPOSICODE()
                If PosicodeDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(POSICODE).Checked = m_Posicode.bEnable
                End If

            Case RSS
                Dim RssDlg As New FRSS()
                If RssDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(RSS).Checked = m_Rss.bEnable
                End If

            Case TELEPEN
                Dim TelepenDlg As New FTELEPEN()
                If TelepenDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(TELEPEN).Checked = m_Telepen.bEnable
                End If

            Case UPCA
                Dim UpcaDlg As New FUPCA()
                If UpcaDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(UPCA).Checked = m_Upca.bEnable
                End If

            Case UPCE
                Dim UpceDlg As New FUPCE()
                If UpceDlg.ShowDialog() = DialogResult.OK Then
                    LV_SYMLIST.Items(UPCE).Checked = m_Upce.bEnable
                End If

        End Select
    End Sub

    Private Sub LV_SYMLIST_ItemCheck(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ItemCheckEventArgs) Handles LV_SYMLIST.ItemCheck
        If (BARCODE_ENABLED(e.Index) = False) Then
            e.NewValue = CheckState.Unchecked
        End If


    End Sub

    Private Sub LV_SYMLIST_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LV_SYMLIST.SelectedIndexChanged
        If (Not (LV_SYMLIST.FocusedItem Is Nothing)) Then
            If (BARCODE_ENABLED(LV_SYMLIST.FocusedItem.Index) = False) Then

                LV_SYMLIST.FocusedItem.Selected = False
                LV_SYMLIST.FocusedItem.Checked = False
            End If
        End If
    End Sub
End Class