﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports ImagerNet

Public Class FSCANOPTION

    Private m_Imager As New Imager
    Private m_DecoderParams As New DECODER_PARAMS
    Public m_bSyncMode As Boolean

    Private Sub FSCANOPTION_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        m_Imager.GetOption(m_DecoderParams)

        If m_bSyncMode Then
            RD_SYNC.Checked = True
        Else
            RD_ASYNC.Checked = True
        End If

        If m_DecoderParams.nSound = 1 Then
            RD_BEEP.Checked = True
        ElseIf m_DecoderParams.nSound = 2 Then
            RD_NONE.Checked = True
        Else
            RD_DEFAULT.Checked = True
        End If

        CB_TIMEOUT.SelectedIndex = m_DecoderParams.nTimeOut - 1

        If m_DecoderParams.bCentering = True Then
            CB_CENTER.Checked = True
            BTN_CENTERING.Enabled = True
        Else
            CB_CENTER.Checked = False
            BTN_CENTERING.Enabled = False
        End If

        If m_DecoderParams.bVibrate = True Then
            CB_VIBRATE.Checked = True
        Else
            CB_VIBRATE.Checked = False
        End If

        If m_DecoderParams.bXmitAimID = True Then
            CB_AIMID.Checked = True
        Else
            CB_AIMID.Checked = False
        End If

        If m_DecoderParams.bContinueMode = True Then
            CB_CONTINUE.Checked = True
        Else
            CB_CONTINUE.Checked = False
        End If

        If m_DecoderParams.bHexMode = True Then
            CB_HEX.Checked = True
        Else
            CB_HEX.Checked = False
        End If

        If (m_Imager.GetDeviceType() = SCAN_DEVICE_TYPE.DEVICE_M3BLACK) Then
            CB_CENTER.Enabled = False
            CB_CONTINUE.Enabled = False
            BTN_DECODE.Enabled = False
        End If



        CB_LIGHTMODE.SelectedIndex = m_DecoderParams.nLightMode
    End Sub

    Private Sub BTN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_OK.Click

        If RD_SYNC.Checked Then
            m_bSyncMode = True
        Else
            m_bSyncMode = False
        End If

        If RD_BEEP.Checked Then
            m_DecoderParams.nSound = 1
        ElseIf RD_NONE.Checked Then
            m_DecoderParams.nSound = 2
        Else
            m_DecoderParams.nSound = 0
        End If

        m_DecoderParams.nTimeOut = CB_TIMEOUT.SelectedIndex + 1

        If CB_CENTER.Checked Then
            m_DecoderParams.bCentering = True
        Else
            m_DecoderParams.bCentering = False
        End If

        If CB_VIBRATE.Checked Then
            m_DecoderParams.bVibrate = True
        Else
            m_DecoderParams.bVibrate = False
        End If

        If CB_AIMID.Checked Then
            m_DecoderParams.bXmitAimID = True
        Else
            m_DecoderParams.bXmitAimID = False
        End If

        If CB_CONTINUE.Checked Then
            m_DecoderParams.bContinueMode = True
        Else
            m_DecoderParams.bContinueMode = False
        End If

        If CB_HEX.Checked Then
            m_DecoderParams.bHexMode = True
        Else
            m_DecoderParams.bHexMode = False
        End If

        m_DecoderParams.nLightMode = CB_LIGHTMODE.SelectedIndex

        m_Imager.SetOption(m_DecoderParams)

        Me.DialogResult = Windows.Forms.DialogResult.OK
    End Sub

    Private Sub BTN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub

    Private Sub BTN_CENTERING_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CENTERING.Click
        Dim Centering As New FCENTERING()

        Centering.ShowDialog()
    End Sub

    Private Sub CB_CENTER_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CB_CENTER.Click
        If CB_CENTER.Checked = True Then
            BTN_CENTERING.Enabled = True
        Else
            BTN_CENTERING.Enabled = False
        End If
    End Sub

    Private Sub BTN_DECODE_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_DECODE.Click
        Dim DecOptionDlg As New FDECOPTION()

        DecOptionDlg.ShowDialog()
    End Sub
End Class