﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports ImagerNet

Public Class FRSS

    Private m_Imager As New Imager
    Private m_Rss As New RSS_PARAMS

    Private Sub FRSS_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        m_Imager.GetRSS(m_Rss)

        CB_ENABLE.Checked = m_Rss.bEnable
        CB_LIMITED.Checked = m_Rss.bRssLim
        CB_EXPENDED.Checked = m_Rss.bRssExp

        TB_MINLEN.Text = m_Rss.nMinLen.ToString()
        TB_MAXLEN.Text = m_Rss.nMaxLen.ToString()

    End Sub

    Private Sub BTN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_OK.Click
        m_Rss.bEnable = CB_ENABLE.Checked
        m_Rss.bRssLim = CB_LIMITED.Checked
        m_Rss.bRssExp = CB_EXPENDED.Checked

        m_Rss.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
        m_Rss.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

        m_Imager.SetRSS(m_Rss)

        Me.DialogResult = Windows.Forms.DialogResult.OK
    End Sub

    Private Sub BTN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub
End Class