﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports ImagerNet

Public Class FIQOPTION
    Private m_Imager As New Imager
    Private m_IQParams As New IQ_PARAMS

    Private Sub FIQOPTION_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        m_Imager.IQGetOption(m_IQParams)

        If m_IQParams.nIQType = 0 Then
            RD_AZTEC.Checked = True
        Else
            RD_CODE39.Checked = True
        End If

        TB_SAVEFOLDER.Text = m_IQParams.szSaveFolder
        CB_SAVEMODE.SelectedIndex = m_IQParams.nSaveMode
        TB_FILENAME.Text = m_IQParams.szFileName
        TB_SAVEFORMAT.Text = ".BMP"
        TB_SAVEFORMAT.Enabled = False

        If CB_SAVEMODE.SelectedIndex = 0 Then
            TB_FILENAME.Enabled = False
        Else
            TB_FILENAME.Enabled = True
        End If
    End Sub

    Private Sub BN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_OK.Click
        If RD_AZTEC.Checked = True Then
            m_IQParams.nIQType = 0
        Else
            m_IQParams.nIQType = 1
        End If

        m_IQParams.szSaveFolder = TB_SAVEFOLDER.Text
        m_IQParams.nSaveMode = CB_SAVEMODE.SelectedIndex
        m_IQParams.szFileName = TB_FILENAME.Text

        m_Imager.IQSetOption(m_IQParams)

        Me.DialogResult = Windows.Forms.DialogResult.OK
    End Sub

    Private Sub BN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub

    Private Sub CB_SAVEMODE_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CB_SAVEMODE.SelectedIndexChanged
        If CB_SAVEMODE.SelectedIndex = 0 Then
            TB_FILENAME.Enabled = False
        Else
            TB_FILENAME.Enabled = True
        End If
    End Sub
End Class