﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports ImagerNet

Public Class FCODE39

    Private m_Imager As New Imager
    Private m_Code39 As New CODE39_PARAMS

    Private Sub FCODE39_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        m_Imager.GetCODE39(m_Code39)

        CB_ENABLE.Checked = m_Code39.bEnable

        If m_Code39.nFormat = 1 Then
            RD_CODE32.Checked = True
        ElseIf m_Code39.nFormat = 2 Then
            RD_TRIOPTIC.Checked = True
        Else
            RD_STANDARD.Checked = True
        End If

        CB_CDV.Checked = m_Code39.bCDV
        CB_XCD.Checked = m_Code39.bXCD
        CB_FULLASCII.Checked = m_Code39.bFullASCII

        TB_MINLEN.Text = m_Code39.nMinLen.ToString()
        TB_MAXLEN.Text = m_Code39.nMaxLen.ToString()

    End Sub

    Private Sub BTN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_OK.Click
        m_Code39.bEnable = CB_ENABLE.Checked

        If RD_CODE32.Checked = 1 Then
            m_Code39.nFormat = 1
        ElseIf RD_TRIOPTIC.Checked = 2 Then
            m_Code39.nFormat = 2
        Else
            m_Code39.nFormat = 0
        End If

        m_Code39.bCDV = CB_CDV.Checked
        m_Code39.bXCD = CB_XCD.Checked
        m_Code39.bFullASCII = CB_FULLASCII.Checked

        m_Code39.nMinLen = Convert.ToInt32(TB_MINLEN.Text)
        m_Code39.nMaxLen = Convert.ToInt32(TB_MAXLEN.Text)

        m_Imager.SetCODE39(m_Code39)

        Me.DialogResult = Windows.Forms.DialogResult.OK
    End Sub

    Private Sub BTN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub
End Class