﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports ImagerNet

Public Class FCAMOPTION

    Private m_Imager As New Imager
    Private m_CamParams As New CAM_PARAMS

    Private Sub FCAMOPTION_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        m_Imager.CAMGetOption(m_CamParams)

        If m_CamParams.nSaveFormat = 0 Then
            RD_JPG.Checked = True
        Else
            RD_BMP.Checked = True
        End If

        NUD_JPEGQUALITY.Value = m_CamParams.nJpegQuality
        CB_RESOLUTION.SelectedIndex = m_CamParams.nResolution
        TB_SAVEFOLDER.Text = m_CamParams.szSaveFolder
        CB_SAVEMODE.SelectedIndex = m_CamParams.nSaveMode
        TB_FILENAME.Text = m_CamParams.szFileName

        If RD_JPG.Checked = True Then
            TB_SAVEFORMAT.Text = ".JPG"
        Else
            TB_SAVEFORMAT.Text = ".BMP"
        End If

        If CB_SAVEMODE.SelectedIndex = 0 Then
            TB_FILENAME.Enabled = False
        Else
            TB_FILENAME.Enabled = True
        End If

        TB_SAVEFORMAT.Enabled = False
    End Sub

    Private Sub BN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_OK.Click
        If RD_JPG.Checked = True Then
            m_CamParams.nSaveFormat = 0
        Else
            m_CamParams.nSaveFormat = 1
        End If

        m_CamParams.nJpegQuality = NUD_JPEGQUALITY.Value
        m_CamParams.nResolution = CB_RESOLUTION.SelectedIndex
        m_CamParams.szSaveFolder = TB_SAVEFOLDER.Text
        m_CamParams.nSaveMode = CB_SAVEMODE.SelectedIndex
        m_CamParams.szFileName = TB_FILENAME.Text

        m_Imager.CAMSetOption(m_CamParams)

        Me.DialogResult = Windows.Forms.DialogResult.OK
    End Sub

    Private Sub BN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub

    Private Sub CB_SAVEMODE_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CB_SAVEMODE.SelectedIndexChanged
        If CB_SAVEMODE.SelectedIndex = 0 Then
            TB_FILENAME.Enabled = False
        Else
            TB_FILENAME.Enabled = True
        End If
    End Sub

    Private Sub RD_JPG_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RD_JPG.Click
        TB_SAVEFORMAT.Text = ".JPG"
    End Sub

    Private Sub RD_BMP_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RD_BMP.Click
        TB_SAVEFORMAT.Text = ".BMP"
    End Sub
End Class