﻿/********************************************************************
created		:	2011/10/11
file base	: 	ImagerTestNet.exe

file ext	:	cs
author		:	Dong-Hyun Eum & Eun-Taek Lee

purpose		:	Imager C# Demo Program
Report		:	2012. 01. 13 [01/13/2011 vision7901] v1.0.0 - Release Version
*********************************************************************/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using Microsoft.Win32;
using System.Threading;
using System.Reflection;
using System.IO;
using ImagerNet; 


namespace ImagerTestNet
{
    public partial class ImagerTestNet : Form
    {
        public Imager m_Imager;
        public DECODER_PARAMS m_DecoderParams;

        public bool m_bResult = false;
        public bool m_bSyncMode = false;
        public bool m_bWinCE = false;

        public string m_strVerInfo;

        public const int m_nHotKeyCE = 133;    // VK_F22(WinCE)      
        public const int m_nHotKeyWM = 125;    // VK_F14(WM)        

        public SCAN_DEVICE_TYPE m_DeviceType;

        public ImagerTestNet()
        {
            InitializeComponent();

            m_Imager = new Imager();
            m_Imager.ImagerDataEvent += new ImagerNet.ImagerDataDelegate(OnScanRead);

            // Get Device Type
            m_DeviceType = m_Imager.GetDeviceType();

            // OS Type
            if ((m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3SMART_CE) || (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3GREEN) || (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3T) || (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3POS) || (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3ORANGEPLUS_CE) || (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3UL10_CE) || (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3TPLUS_CE) || (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3BLACK_CE))
                m_bWinCE = true;

            //Imager Open
            if (!m_Imager.Open()) 
            {
                MessageBox.Show("OPEN FAIL !!!");
                Close();
            }
            

            if (m_bWinCE == true)
                m_Imager.RegHotKey(1, m_nHotKeyCE, m_bSyncMode);
            else
                m_Imager.RegHotKey(1, m_nHotKeyWM, m_bSyncMode);

            m_Imager.SetSymbologyAll();

            if (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3BLACK)
                BN_IQIMAING.Enabled = false;
        }


        public void OnScanRead(object sender, ImagerDataArgs e)
        {
            if (e.ScanData != "")
            {
                LB_TYPE.Text = e.ScanType;
                TB_DATA.Text = e.ScanData;
            }
        }

        private void ImagerTestNet_Closing(object sender, CancelEventArgs e)
        {
            m_Imager.UnRegHotKey(1);

            for (int i = 0; i < 3; i++)
            {
                m_bResult = m_Imager.Close();
                Thread.Sleep(300);
                if (m_bResult == true)
                    break;
            }
        }    

        private void BN_SCAN_Click(object sender, EventArgs e)
        {
            m_Imager.Read();
        }

        private void BN_SCANCANCEL_Click(object sender, EventArgs e)
        {
            m_Imager.ReadCancel();
        }

        private void BN_SYM_Click(object sender, EventArgs e)
        {
            FSYMBOLOGY Symbology = new FSYMBOLOGY();

            // Disable Scan Key
            m_Imager.ReadCancel();
            m_Imager.UnRegHotKey(1);

            Symbology.ShowDialog();

            // Enable Scan Key
            if (m_bWinCE == true)
                m_Imager.RegHotKey(1, m_nHotKeyCE, m_bSyncMode);
            else
                m_Imager.RegHotKey(1, m_nHotKeyWM, m_bSyncMode);
        }

        private void BN_SCANOPTION_Click(object sender, EventArgs e)
        {
            FSCANOPTION ScanOption = new FSCANOPTION();

            ScanOption.m_bSyncMode = m_bSyncMode;

            // Disable Scan Key
            m_Imager.ReadCancel();
            m_Imager.UnRegHotKey(1);

            if(ScanOption.ShowDialog() == DialogResult.OK)
                m_bSyncMode = ScanOption.m_bSyncMode;

            // Enable Scan Key
            if (m_bWinCE == true)
                m_Imager.RegHotKey(1, m_nHotKeyCE, m_bSyncMode);
            else
                m_Imager.RegHotKey(1, m_nHotKeyWM, m_bSyncMode);
        }

        private void BN_CAMTEST_Click(object sender, EventArgs e)
        {
            m_Imager.ReadCancel();

            FCAMTEST CamTest = new FCAMTEST();
            CamTest.m_Imager = m_Imager;

            CamTest.ShowDialog();
        }

        private void BN_IQIMAING_Click(object sender, EventArgs e)
        {
            m_Imager.ReadCancel();

            FIQTEST IQTest = new FIQTEST();           

            m_Imager.ImagerDataEvent -= new ImagerDataDelegate(OnScanRead);

            IQTest.m_Imager = m_Imager;

            IQTest.ShowDialog();
            
            m_Imager.ImagerDataEvent += new ImagerDataDelegate(OnScanRead);       
        }

        private void BN_NEW_Click(object sender, EventArgs e)
        {
            FTEST NewForm = new FTEST();

            m_Imager.ReadCancel();

            m_Imager.ImagerDataEvent -= new ImagerDataDelegate(OnScanRead);

            NewForm.ShowDialog();
            
            m_Imager.ImagerDataEvent += new ImagerDataDelegate(OnScanRead);            
        }

        private void BN_INFO_Click(object sender, EventArgs e)
        {
            FABOUT AboutDlg = new FABOUT();

            AboutDlg.m_strVersion = m_Imager.GetVersionInfo();

            // Disable Scan Key
            m_Imager.ReadCancel();
            m_Imager.UnRegHotKey(1);

            AboutDlg.ShowDialog();

            // Enable Scan Key
            if (m_bWinCE == true)
                m_Imager.RegHotKey(1, m_nHotKeyCE, m_bSyncMode);
            else
                m_Imager.RegHotKey(1, m_nHotKeyWM, m_bSyncMode);
        }       

        private void BN_CLOSE_Click(object sender, EventArgs e)
        {
            m_Imager.ReadCancel();

            Close();

            Application.Exit();
        }

           
    }
}